/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class PaloOptions
extends OptionHolder {
    private static volatile PaloOptions instance;
    public static final ConfigOption<String> PALO_HOST;
    public static final ConfigOption<Integer> PALO_HTTP_PORT;
    public static final ConfigOption<Integer> PALO_HTTP_TIMEOUT;
    public static final ConfigOption<String> PALO_USERNAME;
    public static final ConfigOption<String> PALO_PASSWORD;
    public static final ConfigOption<Integer> PALO_POLL_INTERVAL;
    public static final ConfigOption<String> PALO_TEMP_DIR;
    public static final ConfigOption<Integer> PALO_FILE_LIMIT_SIZE;

    private PaloOptions() {
    }

    public static synchronized PaloOptions instance() {
        if (instance == null) {
            instance = new PaloOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        PALO_HOST = new ConfigOption("palo.host", "The host/ip of Palo cluster.", OptionChecker.disallowEmpty(), (Object)"127.0.0.1");
        PALO_HTTP_PORT = new ConfigOption("palo.http_port", "The http port of Palo cluster.", OptionChecker.positiveInt(), (Object)8030);
        PALO_HTTP_TIMEOUT = new ConfigOption("palo.http_timeout", "Timeout(second) for connecting and reading Palo.", OptionChecker.nonNegativeInt(), (Object)20);
        PALO_USERNAME = new ConfigOption("palo.username", "The username to login Palo.", OptionChecker.disallowEmpty(), (Object)"root");
        PALO_PASSWORD = new ConfigOption("palo.password", "The password corresponding to palo.username.", null, (Object)"");
        PALO_POLL_INTERVAL = new ConfigOption("palo.poll_interval", "The execution period of the background thread that check whether need to load file data into Palo.", OptionChecker.rangeInt((Number)5, (Number)Integer.MAX_VALUE), (Object)5);
        PALO_TEMP_DIR = new ConfigOption("palo.temp_dir", "The temporary directory to store table files.", null, (Object)"palo-data");
        PALO_FILE_LIMIT_SIZE = new ConfigOption("palo.file_limit_size", "The maximum size(MB) of each file for loading into Palo.", OptionChecker.rangeInt((Number)10, (Number)1000), (Object)50);
    }
}

