/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.receiver.edge;

import org.apache.hugegraph.computer.core.combiner.EdgeValueCombiner;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.receiver.MessageRecvPartition;
import org.apache.hugegraph.computer.core.sort.flusher.CombineSubKvOuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.sorting.SortManager;
import org.apache.hugegraph.computer.core.store.SuperstepFileGenerator;
import org.apache.hugegraph.config.TypedOption;

public class EdgeMessageRecvPartition
extends MessageRecvPartition {
    private static final String TYPE = MessageType.EDGE.name().toLowerCase();
    private final OuterSortFlusher flusher;

    public EdgeMessageRecvPartition(ComputerContext context, SuperstepFileGenerator fileGenerator, SortManager sortManager) {
        super(context.config(), fileGenerator, sortManager, true);
        Config config = context.config();
        int flushThreshold = (Integer)config.get((TypedOption)ComputerOptions.INPUT_MAX_EDGES_IN_ONE_VERTEX);
        EdgeValueCombiner combiner = new EdgeValueCombiner(context);
        this.flusher = new CombineSubKvOuterSortFlusher(combiner, flushThreshold);
    }

    @Override
    protected OuterSortFlusher outerSortFlusher() {
        return this.flusher;
    }

    @Override
    protected String type() {
        return TYPE;
    }
}

