/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import org.apache.hadoop.hbase.hbtop.terminal.Color;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class EscapeSequences {
    private EscapeSequences() {
    }

    public static String clearAll() {
        return "\u001b[0;37;40m\u001b[2J";
    }

    public static String setTitle(String title) {
        return "\u001b]2;" + title + "\u0007";
    }

    public static String cursor(boolean on) {
        if (on) {
            return "\u001b[?25h";
        }
        return "\u001b[?25l";
    }

    public static String moveCursor(int column, int row) {
        return String.format("\u001b[%d;%dH", row + 1, column + 1);
    }

    public static String clearRemainingLine() {
        return "\u001b[0;37;40m\u001b[K";
    }

    public static String color(Color foregroundColor, Color backgroundColor, boolean bold, boolean reverse, boolean blink, boolean underline) {
        int foregroundColorValue = EscapeSequences.getColorValue(foregroundColor, true);
        int backgroundColorValue = EscapeSequences.getColorValue(backgroundColor, false);
        StringBuilder sb = new StringBuilder();
        if (bold && reverse && blink && !underline) {
            sb.append("\u001b[0;1;7;5;");
        } else if (bold && reverse && !blink && !underline) {
            sb.append("\u001b[0;1;7;");
        } else if (!bold && reverse && blink && !underline) {
            sb.append("\u001b[0;7;5;");
        } else if (bold && !reverse && blink && !underline) {
            sb.append("\u001b[0;1;5;");
        } else if (bold && !reverse && !blink && !underline) {
            sb.append("\u001b[0;1;");
        } else if (!bold && reverse && !blink && !underline) {
            sb.append("\u001b[0;7;");
        } else if (!bold && !reverse && blink && !underline) {
            sb.append("\u001b[0;5;");
        } else if (bold && reverse && blink) {
            sb.append("\u001b[0;1;7;5;4;");
        } else if (bold && reverse) {
            sb.append("\u001b[0;1;7;4;");
        } else if (!bold && reverse && blink) {
            sb.append("\u001b[0;7;5;4;");
        } else if (bold && blink) {
            sb.append("\u001b[0;1;5;4;");
        } else if (bold) {
            sb.append("\u001b[0;1;4;");
        } else if (reverse) {
            sb.append("\u001b[0;7;4;");
        } else if (blink) {
            sb.append("\u001b[0;5;4;");
        } else if (underline) {
            sb.append("\u001b[0;4;");
        } else {
            sb.append("\u001b[0;");
        }
        sb.append(String.format("%d;%dm", foregroundColorValue, backgroundColorValue));
        return sb.toString();
    }

    private static int getColorValue(Color color, boolean foreground) {
        int baseValue = foreground ? 30 : 40;
        switch (color) {
            case BLACK: {
                return baseValue;
            }
            case RED: {
                return baseValue + 1;
            }
            case GREEN: {
                return baseValue + 2;
            }
            case YELLOW: {
                return baseValue + 3;
            }
            case BLUE: {
                return baseValue + 4;
            }
            case MAGENTA: {
                return baseValue + 5;
            }
            case CYAN: {
                return baseValue + 6;
            }
            case WHITE: {
                return baseValue + 7;
            }
        }
        throw new AssertionError();
    }

    public static String normal() {
        return "\u001b[0;37;40m";
    }
}

