/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.metrics.CustomResourceMetricValue;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class CustomResourceMetrics {
    private static final String ALLOCATED_RESOURCE_METRIC_PREFIX = "AllocatedResource.";
    private static final String ALLOCATED_RESOURCE_METRIC_DESC = "Allocated NAME";
    private static final String AVAILABLE_RESOURCE_METRIC_PREFIX = "AvailableResource.";
    private static final String AVAILABLE_RESOURCE_METRIC_DESC = "Available NAME";
    private final CustomResourceMetricValue allocated = new CustomResourceMetricValue();
    private final CustomResourceMetricValue available = new CustomResourceMetricValue();

    public void registerCustomResources(Map<String, Long> customResources, MetricsRegistry registry) {
        this.registerCustomResources(customResources, registry, ALLOCATED_RESOURCE_METRIC_PREFIX, ALLOCATED_RESOURCE_METRIC_DESC);
        this.registerCustomResources(customResources, registry, AVAILABLE_RESOURCE_METRIC_PREFIX, AVAILABLE_RESOURCE_METRIC_DESC);
    }

    public Map<String, Long> initAndGetCustomResources() {
        HashMap<String, Long> customResources = new HashMap<String, Long>();
        ResourceInformation[] resources = ResourceUtils.getResourceTypesArray();
        for (int i = 2; i < resources.length; ++i) {
            ResourceInformation resource = resources[i];
            customResources.put(resource.getName(), 0L);
        }
        return customResources;
    }

    public void registerCustomResources(Map<String, Long> customResources, MetricsRegistry registry, String metricPrefix, String metricDesc) {
        for (Map.Entry<String, Long> entry : customResources.entrySet()) {
            String resourceName = entry.getKey();
            Long resourceValue = entry.getValue();
            MutableGaugeLong resourceMetric = (MutableGaugeLong)registry.get(metricPrefix + resourceName);
            if (resourceMetric == null) {
                resourceMetric = registry.newGauge(metricPrefix + resourceName, metricDesc.replace("NAME", resourceName), 0L);
            }
            resourceMetric.set(resourceValue.longValue());
        }
    }

    public void setAvailable(Resource res) {
        this.available.set(res);
    }

    public void increaseAllocated(Resource res) {
        this.allocated.increase(res);
    }

    public void increaseAllocated(Resource res, int containers) {
        this.allocated.increaseWithMultiplier(res, containers);
    }

    public void decreaseAllocated(Resource res) {
        this.allocated.decrease(res);
    }

    public void decreaseAllocated(Resource res, int containers) {
        this.allocated.decreaseWithMultiplier(res, containers);
    }

    public Map<String, Long> getAllocatedValues() {
        return this.allocated.getValues();
    }

    public Map<String, Long> getAvailableValues() {
        return this.available.getValues();
    }

    public CustomResourceMetricValue getAvailable() {
        return this.available;
    }
}

