/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.xml.service;

import java.util.Collection;
import org.apache.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import org.apache.hadoop.shaded.org.ehcache.config.builders.CacheConfigurationBuilder;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ServiceUtils;
import org.apache.hadoop.shaded.org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.CoreServiceConfigurationParser;
import org.apache.hadoop.shaded.org.ehcache.xml.XmlConfiguration;
import org.apache.hadoop.shaded.org.ehcache.xml.exceptions.XmlConfigurationException;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheTemplate;
import org.apache.hadoop.shaded.org.ehcache.xml.model.CacheType;

public class DefaultSerializerConfigurationParser
implements CoreServiceConfigurationParser {
    @Override
    public <K, V> CacheConfigurationBuilder<K, V> parseServiceConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        if (cacheDefinition.keySerializer() != null) {
            Class<?> keySerializer = XmlConfiguration.getClassForName(cacheDefinition.keySerializer(), cacheClassLoader);
            cacheBuilder = cacheBuilder.withService((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, DefaultSerializerConfiguration.Type.KEY));
        }
        if (cacheDefinition.valueSerializer() != null) {
            Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheDefinition.valueSerializer(), cacheClassLoader);
            cacheBuilder = cacheBuilder.withService((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
        }
        return cacheBuilder;
    }

    @Override
    public CacheType unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        Collection<DefaultSerializerConfiguration> serializerConfigs = ServiceUtils.findAmongst(DefaultSerializerConfiguration.class, cacheConfiguration.getServiceConfigurations());
        for (DefaultSerializerConfiguration serializerConfig : serializerConfigs) {
            if (serializerConfig.getInstance() == null) {
                if (serializerConfig.getType() == DefaultSerializerConfiguration.Type.KEY) {
                    cacheType.getKeyType().setSerializer(serializerConfig.getClazz().getName());
                    continue;
                }
                cacheType.getValueType().setSerializer(serializerConfig.getClazz().getName());
                continue;
            }
            throw new XmlConfigurationException("XML translation for instance based initialization for DefaultSerializerConfiguration is not supported");
        }
        return cacheType;
    }
}

