/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.time.Duration;
import rx.Single;

public class InvalidPartitionExceptionRetryPolicy
implements IDocumentClientRetryPolicy {
    private final RxCollectionCache clientCollectionCache;
    private final IDocumentClientRetryPolicy nextPolicy;
    private final String collectionLink;
    private final FeedOptions feedOptions;
    private volatile boolean retried = false;

    public InvalidPartitionExceptionRetryPolicy(RxCollectionCache collectionCache, IDocumentClientRetryPolicy nextPolicy, String resourceFullName, FeedOptions feedOptions) {
        this.clientCollectionCache = collectionCache;
        this.nextPolicy = nextPolicy;
        this.collectionLink = com.microsoft.azure.cosmosdb.internal.Utils.getCollectionName((String)resourceFullName);
        this.feedOptions = feedOptions;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        DocumentClientException clientException = (DocumentClientException)((Object)Utils.as((Object)e, DocumentClientException.class));
        if (clientException != null && Exceptions.isStatusCode((DocumentClientException)clientException, (int)410) && Exceptions.isSubStatusCode((DocumentClientException)clientException, (int)1000)) {
            if (!this.retried) {
                if (this.feedOptions != null) {
                    this.clientCollectionCache.refresh(this.collectionLink, this.feedOptions.getProperties());
                } else {
                    this.clientCollectionCache.refresh(this.collectionLink, null);
                }
                this.retried = true;
                return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
            }
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
        }
        return this.nextPolicy.shouldRetry(e);
    }
}

