/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Address;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpClientUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressCache;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.PartitionKeyRangeGoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ServiceConfig;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.rx.internal.AuthorizationTokenType;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.caches.AsyncCache;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.Observable;
import rx.Single;

public class GatewayAddressCache
implements IAddressCache {
    private static final Logger logger = LoggerFactory.getLogger(GatewayAddressCache.class);
    private static final String protocolFilterFormat = "%s eq %s";
    private static final int DefaultBatchSize = 50;
    private static final int DefaultSuboptimalPartitionForceRefreshIntervalInSeconds = 600;
    private final ServiceConfig serviceConfig = ServiceConfig.getInstance();
    private final String databaseFeedEntryUrl = PathsHelper.generatePath((ResourceType)ResourceType.Database, (String)"", (boolean)true);
    private final URL serviceEndpoint;
    private final URL addressEndpoint;
    private final AsyncCache<PartitionKeyRangeIdentity, AddressInformation[]> serverPartitionAddressCache;
    private final ConcurrentHashMap<PartitionKeyRangeIdentity, Instant> suboptimalServerPartitionTimestamps;
    private final long suboptimalPartitionForceRefreshIntervalInSeconds;
    private final String protocolScheme;
    private final String protocolFilter;
    private final IAuthorizationTokenProvider tokenProvider;
    private final HashMap<String, String> defaultRequestHeaders;
    private final CompositeHttpClient<ByteBuf, ByteBuf> httpClient;
    private volatile Pair<PartitionKeyRangeIdentity, AddressInformation[]> masterPartitionAddressCache;
    private volatile Instant suboptimalMasterPartitionTimestamp;

    public GatewayAddressCache(URL serviceEndpoint, Protocol protocol, IAuthorizationTokenProvider tokenProvider, UserAgentContainer userAgent, CompositeHttpClient<ByteBuf, ByteBuf> httpClient, long suboptimalPartitionForceRefreshIntervalInSeconds) {
        try {
            this.addressEndpoint = new URL(serviceEndpoint, "addresses");
        }
        catch (MalformedURLException e) {
            logger.error("serviceEndpoint {} is invalid", (Object)serviceEndpoint, (Object)e);
            assert (false);
            throw new IllegalStateException(e);
        }
        this.tokenProvider = tokenProvider;
        this.serviceEndpoint = serviceEndpoint;
        this.serverPartitionAddressCache = new AsyncCache();
        this.suboptimalServerPartitionTimestamps = new ConcurrentHashMap();
        this.suboptimalMasterPartitionTimestamp = Instant.MAX;
        this.suboptimalPartitionForceRefreshIntervalInSeconds = suboptimalPartitionForceRefreshIntervalInSeconds;
        this.protocolScheme = protocol.scheme();
        this.protocolFilter = String.format(protocolFilterFormat, "protocol", this.protocolScheme);
        this.httpClient = httpClient;
        if (userAgent == null) {
            userAgent = new UserAgentContainer();
        }
        this.defaultRequestHeaders = new HashMap();
        this.defaultRequestHeaders.put("User-Agent", userAgent.getUserAgent());
        this.defaultRequestHeaders.put("x-ms-version", "2018-09-17");
    }

    public GatewayAddressCache(URL serviceEndpoint, Protocol protocol, IAuthorizationTokenProvider tokenProvider, UserAgentContainer userAgent, CompositeHttpClient<ByteBuf, ByteBuf> httpClient) {
        this(serviceEndpoint, protocol, tokenProvider, userAgent, httpClient, 600L);
    }

    private URL getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    @Override
    public Single<AddressInformation[]> tryGetAddresses(RxDocumentServiceRequest request, PartitionKeyRangeIdentity partitionKeyRangeIdentity, boolean forceRefreshPartitionAddresses) {
        boolean forceRefreshPartitionAddressesModified;
        com.microsoft.azure.cosmosdb.rx.internal.Utils.checkNotNullOrThrow((Object)request, (String)"request", (String)"");
        com.microsoft.azure.cosmosdb.rx.internal.Utils.checkNotNullOrThrow((Object)partitionKeyRangeIdentity, (String)"partitionKeyRangeIdentity", (String)"");
        if (StringUtils.equals((CharSequence)partitionKeyRangeIdentity.getPartitionKeyRangeId(), (CharSequence)"M")) {
            return this.resolveMasterAsync(request, forceRefreshPartitionAddresses, request.properties).map(r -> (AddressInformation[])r.getRight());
        }
        Instant suboptimalServerPartitionTimestamp = this.suboptimalServerPartitionTimestamps.get(partitionKeyRangeIdentity);
        if (suboptimalServerPartitionTimestamp != null) {
            Instant newValue;
            boolean forceRefreshDueToSuboptimalPartitionReplicaSet;
            boolean bl = forceRefreshDueToSuboptimalPartitionReplicaSet = Duration.between(suboptimalServerPartitionTimestamp, Instant.now()).getSeconds() > this.suboptimalPartitionForceRefreshIntervalInSeconds;
            if (forceRefreshDueToSuboptimalPartitionReplicaSet && !(newValue = this.suboptimalServerPartitionTimestamps.computeIfPresent(partitionKeyRangeIdentity, (key, oldVal) -> {
                if (suboptimalServerPartitionTimestamp.equals(oldVal)) {
                    return Instant.MAX;
                }
                return oldVal;
            })).equals(suboptimalServerPartitionTimestamp)) {
                forceRefreshPartitionAddresses = true;
            }
        }
        if (forceRefreshPartitionAddressesModified = forceRefreshPartitionAddresses) {
            this.serverPartitionAddressCache.refresh((Object)partitionKeyRangeIdentity, () -> this.getAddressesForRangeId(request, partitionKeyRangeIdentity.getCollectionRid(), partitionKeyRangeIdentity.getPartitionKeyRangeId(), true));
            this.suboptimalServerPartitionTimestamps.remove(partitionKeyRangeIdentity);
        }
        Single addressesObs = this.serverPartitionAddressCache.getAsync((Object)partitionKeyRangeIdentity, null, () -> this.getAddressesForRangeId(request, partitionKeyRangeIdentity.getCollectionRid(), partitionKeyRangeIdentity.getPartitionKeyRangeId(), false));
        return addressesObs.map(addresses -> {
            if (this.notAllReplicasAvailable((AddressInformation[])addresses)) {
                this.suboptimalServerPartitionTimestamps.putIfAbsent(partitionKeyRangeIdentity, Instant.now());
            }
            return addresses;
        }).onErrorResumeNext(ex -> {
            DocumentClientException dce = (DocumentClientException)((Object)((Object)com.microsoft.azure.cosmosdb.rx.internal.Utils.as((Object)ex, DocumentClientException.class)));
            if (dce == null) {
                if (forceRefreshPartitionAddressesModified) {
                    this.suboptimalServerPartitionTimestamps.remove(partitionKeyRangeIdentity);
                }
                return Single.error((Throwable)ex);
            }
            assert (dce != null);
            if (Exceptions.isStatusCode((DocumentClientException)dce, (int)404) || Exceptions.isStatusCode((DocumentClientException)dce, (int)410) || Exceptions.isSubStatusCode((DocumentClientException)dce, (int)1002)) {
                this.suboptimalServerPartitionTimestamps.remove(partitionKeyRangeIdentity);
                return null;
            }
            return Single.error((Throwable)ex);
        });
    }

    Single<List<Address>> getServerAddressesViaGatewayAsync(RxDocumentServiceRequest request, String collectionRid, List<String> partitionKeyRangeIds, boolean forceRefresh) {
        String entryUrl = PathsHelper.generatePath((ResourceType)ResourceType.Document, (String)collectionRid, (boolean)true);
        HashMap<String, String> addressQuery = new HashMap<String, String>();
        addressQuery.put("$resolveFor", HttpUtils.urlEncode((String)entryUrl));
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultRequestHeaders);
        if (forceRefresh) {
            headers.put("x-ms-force-refresh", Boolean.TRUE.toString());
        }
        addressQuery.put("$filter", HttpUtils.urlEncode((String)this.protocolFilter));
        addressQuery.put("$partitionKeyRangeIds", String.join((CharSequence)",", partitionKeyRangeIds));
        headers.put("x-ms-date", Utils.nowAsRFC1123());
        String token = null;
        token = this.tokenProvider.getUserAuthorizationToken(collectionRid, ResourceType.Document, "GET", headers, AuthorizationTokenType.PrimaryMasterKey, request.properties);
        if (token == null && request.getIsNameBased()) {
            String collectionAltLink = PathsHelper.getCollectionPath((String)request.getResourceAddress());
            token = this.tokenProvider.getUserAuthorizationToken(collectionAltLink, ResourceType.Document, "GET", headers, AuthorizationTokenType.PrimaryMasterKey, request.properties);
        }
        token = HttpUtils.urlEncode((String)token);
        headers.put("authorization", token);
        URL targetEndpoint = Utils.setQuery((String)this.addressEndpoint.toString(), (String)Utils.createQuery(addressQuery));
        String identifier = GatewayAddressCache.logAddressResolutionStart(request, targetEndpoint);
        HttpClientRequest httpGet = HttpClientRequest.createGet((String)targetEndpoint.toString());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpGet.withHeader(entry.getKey(), entry.getValue());
        }
        RxClient.ServerInfo serverInfo = new RxClient.ServerInfo(targetEndpoint.getHost(), targetEndpoint.getPort());
        Observable responseObs = this.httpClient.submit(serverInfo, httpGet);
        Single dsrObs = responseObs.toSingle().flatMap(rsp -> HttpClientUtils.parseResponseAsync((HttpClientResponse<ByteBuf>)rsp));
        return dsrObs.map(dsr -> {
            GatewayAddressCache.logAddressResolutionEnd(request, identifier);
            List addresses = dsr.getQueryResponse(Address.class);
            return addresses;
        });
    }

    public void dispose() {
    }

    private Single<Pair<PartitionKeyRangeIdentity, AddressInformation[]>> resolveMasterAsync(RxDocumentServiceRequest request, boolean forceRefresh, Map<String, Object> properties) {
        Pair<PartitionKeyRangeIdentity, AddressInformation[]> masterAddressAndRangeInitial = this.masterPartitionAddressCache;
        boolean bl = forceRefresh = forceRefresh || masterAddressAndRangeInitial != null && this.notAllReplicasAvailable((AddressInformation[])masterAddressAndRangeInitial.getRight()) && Duration.between(this.suboptimalMasterPartitionTimestamp, Instant.now()).getSeconds() > this.suboptimalPartitionForceRefreshIntervalInSeconds;
        if (forceRefresh || this.masterPartitionAddressCache == null) {
            Single<List<Address>> masterReplicaAddressesObs = this.getMasterAddressesViaGatewayAsync(request, ResourceType.Database, null, this.databaseFeedEntryUrl, forceRefresh, false, properties);
            return masterReplicaAddressesObs.map(masterAddresses -> {
                Pair<PartitionKeyRangeIdentity, AddressInformation[]> masterAddressAndRangeRes = this.toPartitionAddressAndRange("", (List<Address>)masterAddresses);
                this.masterPartitionAddressCache = masterAddressAndRangeRes;
                this.suboptimalMasterPartitionTimestamp = this.notAllReplicasAvailable((AddressInformation[])masterAddressAndRangeRes.getRight()) && this.suboptimalMasterPartitionTimestamp.equals(Instant.MAX) ? Instant.now() : Instant.MAX;
                return this.masterPartitionAddressCache;
            }).doOnError(e -> {
                this.suboptimalMasterPartitionTimestamp = Instant.MAX;
            });
        }
        if (this.notAllReplicasAvailable((AddressInformation[])masterAddressAndRangeInitial.getRight()) && this.suboptimalMasterPartitionTimestamp.equals(Instant.MAX)) {
            this.suboptimalMasterPartitionTimestamp = Instant.now();
        }
        return Single.just(masterAddressAndRangeInitial);
    }

    private Single<AddressInformation[]> getAddressesForRangeId(RxDocumentServiceRequest request, String collectionRid, String partitionKeyRangeId, boolean forceRefresh) {
        Single<List<Address>> addressResponse = this.getServerAddressesViaGatewayAsync(request, collectionRid, Collections.singletonList(partitionKeyRangeId), forceRefresh);
        Single addressInfos = addressResponse.map(addresses -> addresses.stream().filter(addressInfo -> this.protocolScheme.equals(addressInfo.getProtocolScheme())).collect(Collectors.groupingBy(address -> address.getParitionKeyRangeId())).values().stream().map(groupedAddresses -> this.toPartitionAddressAndRange(collectionRid, (List<Address>)addresses)).collect(Collectors.toList()));
        Single result = addressInfos.map(addressInfo -> addressInfo.stream().filter(a -> StringUtils.equals((CharSequence)((PartitionKeyRangeIdentity)a.getLeft()).getPartitionKeyRangeId(), (CharSequence)partitionKeyRangeId)).collect(Collectors.toList()));
        return result.flatMap(list -> {
            if (list.isEmpty()) {
                String errorMessage = String.format("PartitionKeyRange with id %s in collection %s doesn't exist", partitionKeyRangeId, collectionRid);
                PartitionKeyRangeGoneException e = new PartitionKeyRangeGoneException(errorMessage);
                BridgeInternal.setResourceAddress((DocumentClientException)e, (String)collectionRid);
                return Single.error((Throwable)((Object)e));
            }
            return Single.just((Object)((Pair)list.get(0)).getRight());
        });
    }

    Single<List<Address>> getMasterAddressesViaGatewayAsync(RxDocumentServiceRequest request, ResourceType resourceType, String resourceAddress, String entryUrl, boolean forceRefresh, boolean useMasterCollectionResolver, Map<String, Object> properties) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("$resolveFor", HttpUtils.urlEncode((String)entryUrl));
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultRequestHeaders);
        if (forceRefresh) {
            headers.put("x-ms-force-refresh", Boolean.TRUE.toString());
        }
        if (useMasterCollectionResolver) {
            headers.put("x-ms-use-master-collection-resolver", Boolean.TRUE.toString());
        }
        queryParameters.put("$filter", HttpUtils.urlEncode((String)this.protocolFilter));
        headers.put("x-ms-date", Utils.nowAsRFC1123());
        String token = this.tokenProvider.getUserAuthorizationToken(resourceAddress, resourceType, "GET", headers, AuthorizationTokenType.PrimaryMasterKey, properties);
        headers.put("authorization", HttpUtils.urlEncode((String)token));
        URL targetEndpoint = Utils.setQuery((String)this.addressEndpoint.toString(), (String)Utils.createQuery(queryParameters));
        String identifier = GatewayAddressCache.logAddressResolutionStart(request, targetEndpoint);
        HttpClientRequest httpGet = HttpClientRequest.createGet((String)targetEndpoint.toString());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpGet.withHeader(entry.getKey(), entry.getValue());
        }
        RxClient.ServerInfo serverInfo = new RxClient.ServerInfo(targetEndpoint.getHost(), targetEndpoint.getPort());
        Observable responseObs = this.httpClient.submit(serverInfo, httpGet);
        Single dsrObs = responseObs.toSingle().flatMap(rsp -> HttpClientUtils.parseResponseAsync((HttpClientResponse<ByteBuf>)rsp));
        return dsrObs.map(dsr -> {
            GatewayAddressCache.logAddressResolutionEnd(request, identifier);
            List addresses = dsr.getQueryResponse(Address.class);
            return addresses;
        });
    }

    private Pair<PartitionKeyRangeIdentity, AddressInformation[]> toPartitionAddressAndRange(String collectionRid, List<Address> addresses) {
        Address address = addresses.get(0);
        AddressInformation[] addressInfos = addresses.stream().map(addr -> GatewayAddressCache.toAddressInformation(addr)).collect(Collectors.toList()).toArray(new AddressInformation[addresses.size()]);
        return Pair.of((Object)new PartitionKeyRangeIdentity(collectionRid, address.getParitionKeyRangeId()), (Object)addressInfos);
    }

    private static AddressInformation toAddressInformation(Address address) {
        return new AddressInformation(true, address.IsPrimary(), address.getPhyicalUri(), address.getProtocolScheme());
    }

    public Completable openAsync(DocumentCollection collection, List<PartitionKeyRangeIdentity> partitionKeyRangeIdentities) {
        ArrayList<Observable> tasks = new ArrayList<Observable>();
        int batchSize = 50;
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (String)collection.getResourceId(), (ResourceType)ResourceType.DocumentCollection, (Map)Collections.EMPTY_MAP);
        for (int i = 0; i < partitionKeyRangeIdentities.size(); i += batchSize) {
            int endIndex = i + batchSize;
            endIndex = endIndex < partitionKeyRangeIdentities.size() ? endIndex : partitionKeyRangeIdentities.size();
            tasks.add(this.getServerAddressesViaGatewayAsync(request, collection.getResourceId(), partitionKeyRangeIdentities.subList(i, endIndex).stream().map(range -> range.getPartitionKeyRangeId()).collect(Collectors.toList()), false).toObservable());
        }
        return Observable.concat(tasks).doOnNext(list -> {
            List addressInfos = list.stream().filter(addressInfo -> this.protocolScheme.equals(addressInfo.getProtocolScheme())).collect(Collectors.groupingBy(address -> address.getParitionKeyRangeId())).entrySet().stream().map(group -> this.toPartitionAddressAndRange(collection.getResourceId(), (List)group.getValue())).collect(Collectors.toList());
            for (Pair addressInfo2 : addressInfos) {
                this.serverPartitionAddressCache.set((Object)new PartitionKeyRangeIdentity(collection.getResourceId(), ((PartitionKeyRangeIdentity)addressInfo2.getLeft()).getPartitionKeyRangeId()), addressInfo2.getRight());
            }
        }).toCompletable();
    }

    private boolean notAllReplicasAvailable(AddressInformation[] addressInformations) {
        ServiceConfig.SystemReplicationPolicy cfr_ignored_0 = this.serviceConfig.userReplicationPolicy;
        return addressInformations.length < 4;
    }

    private static String logAddressResolutionStart(RxDocumentServiceRequest request, URL targetEndpointUrl) {
        try {
            if (request.requestContext.clientSideRequestStatistics != null) {
                return request.requestContext.clientSideRequestStatistics.recordAddressResolutionStart(targetEndpointUrl.toURI());
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    private static void logAddressResolutionEnd(RxDocumentServiceRequest request, String identifier) {
        if (request.requestContext.clientSideRequestStatistics != null) {
            request.requestContext.clientSideRequestStatistics.recordAddressResolutionEnd(identifier);
        }
    }
}

