/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerPermission;

public class BasicAuthorizerRole {
    private static final Logger log = new Logger(BasicAuthorizerRole.class);
    private final String name;
    private final List<BasicAuthorizerPermission> permissions;

    @JsonCreator
    public BasicAuthorizerRole(@JsonProperty(value="name") String name, @JsonProperty(value="permissions") @JsonDeserialize(using=PermissionsDeserializer.class) List<BasicAuthorizerPermission> permissions) {
        this.name = name;
        this.permissions = permissions == null ? new ArrayList() : permissions;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<BasicAuthorizerPermission> getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuthorizerRole role = (BasicAuthorizerRole)o;
        if (this.getName() != null ? !this.getName().equals(role.getName()) : role.getName() != null) {
            return false;
        }
        return this.getPermissions() != null ? this.getPermissions().equals(role.getPermissions()) : role.getPermissions() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getPermissions() != null ? this.getPermissions().hashCode() : 0);
        return result;
    }

    static class PermissionsDeserializer
    extends JsonDeserializer<List<BasicAuthorizerPermission>> {
        PermissionsDeserializer() {
        }

        public List<BasicAuthorizerPermission> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<BasicAuthorizerPermission> permissions = new ArrayList<BasicAuthorizerPermission>();
            ObjectCodec codec = jsonParser.getCodec();
            JsonNode hopefullyAnArray = (JsonNode)codec.readTree(jsonParser);
            if (!hopefullyAnArray.isArray()) {
                throw new RE("Failed to deserialize authorizer role list", new Object[0]);
            }
            for (JsonNode node : hopefullyAnArray) {
                try {
                    permissions.add((BasicAuthorizerPermission)codec.treeToValue((TreeNode)node, BasicAuthorizerPermission.class));
                }
                catch (JsonProcessingException e) {
                    log.warn((Throwable)e, "Failed to deserialize authorizer role, ignoring: %s", new Object[]{node.toPrettyString()});
                }
            }
            return permissions;
        }
    }
}

