/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.vector;

import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.vector.DoubleHllSketchBuildVectorProcessor;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessor;
import org.apache.druid.query.aggregation.datasketches.hll.vector.LongHllSketchBuildVectorProcessor;
import org.apache.druid.query.aggregation.datasketches.hll.vector.MultiValueStringHllSketchBuildVectorProcessor;
import org.apache.druid.query.aggregation.datasketches.hll.vector.ObjectHllSketchBuildVectorProcessor;
import org.apache.druid.query.aggregation.datasketches.hll.vector.SingleValueStringHllSketchBuildVectorProcessor;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class HllSketchBuildVectorProcessorFactory
implements VectorColumnProcessorFactory<HllSketchBuildVectorProcessor> {
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final StringEncoding stringEncoding;

    public HllSketchBuildVectorProcessorFactory(HllSketchBuildBufferAggregatorHelper helper, StringEncoding stringEncoding) {
        this.helper = helper;
        this.stringEncoding = stringEncoding;
    }

    public HllSketchBuildVectorProcessor makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
        return new SingleValueStringHllSketchBuildVectorProcessor(this.helper, this.stringEncoding, selector);
    }

    public HllSketchBuildVectorProcessor makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
        return new MultiValueStringHllSketchBuildVectorProcessor(this.helper, this.stringEncoding, selector);
    }

    public HllSketchBuildVectorProcessor makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        return new DoubleHllSketchBuildVectorProcessor(this.helper, selector);
    }

    public HllSketchBuildVectorProcessor makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        return new DoubleHllSketchBuildVectorProcessor(this.helper, selector);
    }

    public HllSketchBuildVectorProcessor makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        return new LongHllSketchBuildVectorProcessor(this.helper, selector);
    }

    public HllSketchBuildVectorProcessor makeArrayProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
        throw DruidException.defensive((String)"ARRAY types are not supported for hll sketch", (Object[])new Object[0]);
    }

    public HllSketchBuildVectorProcessor makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
        return new ObjectHllSketchBuildVectorProcessor(this.helper, this.stringEncoding, selector);
    }
}

