/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AddPartitionsToTxnResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    AddPartitionsToTxnResultCollection resultsByTransaction;
    AddPartitionsToTxnTopicResultCollection resultsByTopicV3AndBelow;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public AddPartitionsToTxnResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddPartitionsToTxnResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.resultsByTransaction = new AddPartitionsToTxnResultCollection(0);
        this.resultsByTopicV3AndBelow = new AddPartitionsToTxnTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 24;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        ImplicitLinkedHashMultiCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _version >= 4 ? _readable.readShort() : (short)0;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resultsByTransaction was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new AddPartitionsToTxnResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnResult(_readable, _version));
            }
            this.resultsByTransaction = newCollection;
        } else {
            this.resultsByTransaction = new AddPartitionsToTxnResultCollection(0);
        }
        if (_version <= 3) {
            if (_version >= 3) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field resultsByTopicV3AndBelow was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AddPartitionsToTxnTopicResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnTopicResult(_readable, _version));
                }
                this.resultsByTopicV3AndBelow = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field resultsByTopicV3AndBelow was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AddPartitionsToTxnTopicResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnTopicResult(_readable, _version));
                }
                this.resultsByTopicV3AndBelow = newCollection;
            }
        } else {
            this.resultsByTopicV3AndBelow = new AddPartitionsToTxnTopicResultCollection(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 4) {
            _writable.writeShort(this.errorCode);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.resultsByTransaction.size() + 1);
            for (AddPartitionsToTxnResult resultsByTransactionElement : this.resultsByTransaction) {
                resultsByTransactionElement.write(_writable, _cache, _version);
            }
        } else if (!this.resultsByTransaction.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default resultsByTransaction at version " + _version);
        }
        if (_version <= 3) {
            if (_version >= 3) {
                _writable.writeUnsignedVarint(this.resultsByTopicV3AndBelow.size() + 1);
                for (AddPartitionsToTxnTopicResult resultsByTopicV3AndBelowElement : this.resultsByTopicV3AndBelow) {
                    resultsByTopicV3AndBelowElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.resultsByTopicV3AndBelow.size());
                for (AddPartitionsToTxnTopicResult resultsByTopicV3AndBelowElement : this.resultsByTopicV3AndBelow) {
                    resultsByTopicV3AndBelowElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.resultsByTopicV3AndBelow.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default resultsByTopicV3AndBelow at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 4) {
            _size.addBytes(2);
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.resultsByTransaction.size() + 1));
            for (AddPartitionsToTxnResult resultsByTransactionElement : this.resultsByTransaction) {
                resultsByTransactionElement.addSize(_size, _cache, _version);
            }
        }
        if (_version <= 3) {
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.resultsByTopicV3AndBelow.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (AddPartitionsToTxnTopicResult resultsByTopicV3AndBelowElement : this.resultsByTopicV3AndBelow) {
                resultsByTopicV3AndBelowElement.addSize(_size, _cache, _version);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnResponseData)) {
            return false;
        }
        AddPartitionsToTxnResponseData other = (AddPartitionsToTxnResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.resultsByTransaction == null ? other.resultsByTransaction != null : !this.resultsByTransaction.equals(other.resultsByTransaction)) {
            return false;
        }
        if (this.resultsByTopicV3AndBelow == null ? other.resultsByTopicV3AndBelow != null : !this.resultsByTopicV3AndBelow.equals(other.resultsByTopicV3AndBelow)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.resultsByTransaction == null ? 0 : this.resultsByTransaction.hashCode());
        hashCode = 31 * hashCode + (this.resultsByTopicV3AndBelow == null ? 0 : this.resultsByTopicV3AndBelow.hashCode());
        return hashCode;
    }

    @Override
    public AddPartitionsToTxnResponseData duplicate() {
        AddPartitionsToTxnResponseData _duplicate = new AddPartitionsToTxnResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        AddPartitionsToTxnResultCollection newResultsByTransaction = new AddPartitionsToTxnResultCollection(this.resultsByTransaction.size());
        for (AddPartitionsToTxnResult _element : this.resultsByTransaction) {
            newResultsByTransaction.add(_element.duplicate());
        }
        _duplicate.resultsByTransaction = newResultsByTransaction;
        AddPartitionsToTxnTopicResultCollection newResultsByTopicV3AndBelow = new AddPartitionsToTxnTopicResultCollection(this.resultsByTopicV3AndBelow.size());
        for (AddPartitionsToTxnTopicResult _element : this.resultsByTopicV3AndBelow) {
            newResultsByTopicV3AndBelow.add(_element.duplicate());
        }
        _duplicate.resultsByTopicV3AndBelow = newResultsByTopicV3AndBelow;
        return _duplicate;
    }

    public String toString() {
        return "AddPartitionsToTxnResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", resultsByTransaction=" + MessageUtil.deepToString(this.resultsByTransaction.iterator()) + ", resultsByTopicV3AndBelow=" + MessageUtil.deepToString(this.resultsByTopicV3AndBelow.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public AddPartitionsToTxnResultCollection resultsByTransaction() {
        return this.resultsByTransaction;
    }

    public AddPartitionsToTxnTopicResultCollection resultsByTopicV3AndBelow() {
        return this.resultsByTopicV3AndBelow;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddPartitionsToTxnResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AddPartitionsToTxnResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public AddPartitionsToTxnResponseData setResultsByTransaction(AddPartitionsToTxnResultCollection v) {
        this.resultsByTransaction = v;
        return this;
    }

    public AddPartitionsToTxnResponseData setResultsByTopicV3AndBelow(AddPartitionsToTxnTopicResultCollection v) {
        this.resultsByTopicV3AndBelow = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results_by_topic_v3_and_below", new ArrayOf(AddPartitionsToTxnTopicResult.SCHEMA_0), "The results for each topic.")));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results_by_topic_v3_and_below", new CompactArrayOf(AddPartitionsToTxnTopicResult.SCHEMA_3), "The results for each topic."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The response top level error code."), new Field("results_by_transaction", new CompactArrayOf(AddPartitionsToTxnResult.SCHEMA_4), "Results categorized by transactional ID."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class AddPartitionsToTxnTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnTopicResult> {
        public AddPartitionsToTxnTopicResultCollection() {
        }

        public AddPartitionsToTxnTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicResultCollection(Iterator<AddPartitionsToTxnTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnTopicResult find(String name) {
            AddPartitionsToTxnTopicResult _key = new AddPartitionsToTxnTopicResult();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnTopicResult> findAll(String name) {
            AddPartitionsToTxnTopicResult _key = new AddPartitionsToTxnTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnTopicResultCollection duplicate() {
            AddPartitionsToTxnTopicResultCollection _duplicate = new AddPartitionsToTxnTopicResultCollection(this.size());
            for (AddPartitionsToTxnTopicResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        AddPartitionsToTxnPartitionResultCollection resultsByPartition;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public AddPartitionsToTxnTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnTopicResult() {
            this.name = "";
            this.resultsByPartition = new AddPartitionsToTxnPartitionResultCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int i;
            AddPartitionsToTxnPartitionResultCollection newCollection;
            int arrayLength;
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 3) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field resultsByPartition was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AddPartitionsToTxnPartitionResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnPartitionResult(_readable, _version));
                }
                this.resultsByPartition = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field resultsByPartition was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AddPartitionsToTxnPartitionResultCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnPartitionResult(_readable, _version));
                }
                this.resultsByPartition = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(this.resultsByPartition.size() + 1);
                _stringBytes = this.resultsByPartition.iterator();
                while (_stringBytes.hasNext()) {
                    AddPartitionsToTxnPartitionResult resultsByPartitionElement = (AddPartitionsToTxnPartitionResult)_stringBytes.next();
                    resultsByPartitionElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.resultsByPartition.size());
                _stringBytes = this.resultsByPartition.iterator();
                while (_stringBytes.hasNext()) {
                    AddPartitionsToTxnPartitionResult resultsByPartitionElement = (AddPartitionsToTxnPartitionResult)_stringBytes.next();
                    resultsByPartitionElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 3) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.resultsByPartition.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (AddPartitionsToTxnPartitionResult resultsByPartitionElement : this.resultsByPartition) {
                resultsByPartitionElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopicResult)) {
                return false;
            }
            AddPartitionsToTxnTopicResult other = (AddPartitionsToTxnTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopicResult)) {
                return false;
            }
            AddPartitionsToTxnTopicResult other = (AddPartitionsToTxnTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.resultsByPartition == null ? other.resultsByPartition != null : !this.resultsByPartition.equals(other.resultsByPartition)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnTopicResult duplicate() {
            AddPartitionsToTxnTopicResult _duplicate = new AddPartitionsToTxnTopicResult();
            _duplicate.name = this.name;
            AddPartitionsToTxnPartitionResultCollection newResultsByPartition = new AddPartitionsToTxnPartitionResultCollection(this.resultsByPartition.size());
            for (AddPartitionsToTxnPartitionResult _element : this.resultsByPartition) {
                newResultsByPartition.add(_element.duplicate());
            }
            _duplicate.resultsByPartition = newResultsByPartition;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", resultsByPartition=" + MessageUtil.deepToString(this.resultsByPartition.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public AddPartitionsToTxnPartitionResultCollection resultsByPartition() {
            return this.resultsByPartition;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopicResult setResultsByPartition(AddPartitionsToTxnPartitionResultCollection v) {
            this.resultsByPartition = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("results_by_partition", new ArrayOf(AddPartitionsToTxnPartitionResult.SCHEMA_0), "The results for each partition")));
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("results_by_partition", new CompactArrayOf(AddPartitionsToTxnPartitionResult.SCHEMA_3), "The results for each partition"), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class AddPartitionsToTxnPartitionResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnPartitionResult> {
        public AddPartitionsToTxnPartitionResultCollection() {
        }

        public AddPartitionsToTxnPartitionResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnPartitionResultCollection(Iterator<AddPartitionsToTxnPartitionResult> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnPartitionResult find(int partitionIndex) {
            AddPartitionsToTxnPartitionResult _key = new AddPartitionsToTxnPartitionResult();
            _key.setPartitionIndex(partitionIndex);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnPartitionResult> findAll(int partitionIndex) {
            AddPartitionsToTxnPartitionResult _key = new AddPartitionsToTxnPartitionResult();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnPartitionResultCollection duplicate() {
            AddPartitionsToTxnPartitionResultCollection _duplicate = new AddPartitionsToTxnPartitionResultCollection(this.size());
            for (AddPartitionsToTxnPartitionResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnPartitionResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int partitionIndex;
        short partitionErrorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public AddPartitionsToTxnPartitionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnPartitionResult() {
            this.partitionIndex = 0;
            this.partitionErrorCode = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            this.partitionIndex = _readable.readInt();
            this.partitionErrorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.partitionErrorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnPartitionResult)) {
                return false;
            }
            AddPartitionsToTxnPartitionResult other = (AddPartitionsToTxnPartitionResult)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnPartitionResult)) {
                return false;
            }
            AddPartitionsToTxnPartitionResult other = (AddPartitionsToTxnPartitionResult)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.partitionErrorCode != other.partitionErrorCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnPartitionResult duplicate() {
            AddPartitionsToTxnPartitionResult _duplicate = new AddPartitionsToTxnPartitionResult();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.partitionErrorCode = this.partitionErrorCode;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnPartitionResult(partitionIndex=" + this.partitionIndex + ", partitionErrorCode=" + this.partitionErrorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short partitionErrorCode() {
            return this.partitionErrorCode;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AddPartitionsToTxnPartitionResult setPartitionErrorCode(short v) {
            this.partitionErrorCode = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition indexes."), new Field("partition_error_code", Type.INT16, "The response error code.")));
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition indexes."), new Field("partition_error_code", Type.INT16, "The response error code."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class AddPartitionsToTxnResultCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnResult> {
        public AddPartitionsToTxnResultCollection() {
        }

        public AddPartitionsToTxnResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnResultCollection(Iterator<AddPartitionsToTxnResult> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnResult find(String transactionalId) {
            AddPartitionsToTxnResult _key = new AddPartitionsToTxnResult();
            _key.setTransactionalId(transactionalId);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnResult> findAll(String transactionalId) {
            AddPartitionsToTxnResult _key = new AddPartitionsToTxnResult();
            _key.setTransactionalId(transactionalId);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnResultCollection duplicate() {
            AddPartitionsToTxnResultCollection _duplicate = new AddPartitionsToTxnResultCollection(this.size());
            for (AddPartitionsToTxnResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String transactionalId;
        AddPartitionsToTxnTopicResultCollection topicResults;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 4;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public AddPartitionsToTxnResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnResult() {
            this.transactionalId = "";
            this.topicResults = new AddPartitionsToTxnTopicResultCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AddPartitionsToTxnResult");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionalId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionalId had invalid length " + length);
            }
            this.transactionalId = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicResults was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            AddPartitionsToTxnTopicResultCollection newCollection = new AddPartitionsToTxnTopicResultCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTopicResult(_readable, _version));
            }
            this.topicResults = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AddPartitionsToTxnResult");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.transactionalId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.topicResults.size() + 1);
            _stringBytes = this.topicResults.iterator();
            while (_stringBytes.hasNext()) {
                AddPartitionsToTxnTopicResult topicResultsElement = (AddPartitionsToTxnTopicResult)_stringBytes.next();
                topicResultsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AddPartitionsToTxnResult");
            }
            byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionalId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicResults.size() + 1));
            for (AddPartitionsToTxnTopicResult topicResultsElement : this.topicResults) {
                topicResultsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnResult)) {
                return false;
            }
            AddPartitionsToTxnResult other = (AddPartitionsToTxnResult)obj;
            return !(this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnResult)) {
                return false;
            }
            AddPartitionsToTxnResult other = (AddPartitionsToTxnResult)obj;
            if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
                return false;
            }
            if (this.topicResults == null ? other.topicResults != null : !this.topicResults.equals(other.topicResults)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnResult duplicate() {
            AddPartitionsToTxnResult _duplicate = new AddPartitionsToTxnResult();
            _duplicate.transactionalId = this.transactionalId;
            AddPartitionsToTxnTopicResultCollection newTopicResults = new AddPartitionsToTxnTopicResultCollection(this.topicResults.size());
            for (AddPartitionsToTxnTopicResult _element : this.topicResults) {
                newTopicResults.add(_element.duplicate());
            }
            _duplicate.topicResults = newTopicResults;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnResult(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", topicResults=" + MessageUtil.deepToString(this.topicResults.iterator()) + ")";
        }

        public String transactionalId() {
            return this.transactionalId;
        }

        public AddPartitionsToTxnTopicResultCollection topicResults() {
            return this.topicResults;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnResult setTransactionalId(String v) {
            this.transactionalId = v;
            return this;
        }

        public AddPartitionsToTxnResult setTopicResults(AddPartitionsToTxnTopicResultCollection v) {
            this.topicResults = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("transactional_id", Type.COMPACT_STRING, "The transactional id corresponding to the transaction."), new Field("topic_results", new CompactArrayOf(AddPartitionsToTxnTopicResult.SCHEMA_3), "The results for each topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5};
        }
    }
}

