/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.lang.reflect.Field;
import java.security.Principal;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.SpnegoLoginService;
import org.eclipse.jetty.security.SpnegoUserPrincipal;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBasedSpnegoLoginService
extends SpnegoLoginService {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBasedSpnegoLoginService.class);
    private static final String TARGET_NAME_FIELD_NAME = "_targetName";
    private final String serverPrincipal;

    public PropertyBasedSpnegoLoginService(String realm, String serverPrincipal) {
        super(realm);
        this.serverPrincipal = Objects.requireNonNull(serverPrincipal);
    }

    protected void doStart() throws Exception {
        Field targetNameField = SpnegoLoginService.class.getDeclaredField(TARGET_NAME_FIELD_NAME);
        targetNameField.setAccessible(true);
        targetNameField.set((Object)this, this.serverPrincipal);
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        String encodedAuthToken = (String)credentials;
        byte[] authToken = B64Code.decode((String)encodedAuthToken);
        GSSManager manager = GSSManager.getInstance();
        try {
            Oid spnegoOid = new Oid("1.3.6.1.5.5.2");
            Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSName gssName = manager.createName(this.serverPrincipal, null);
            GSSCredential serverCreds = manager.createCredential(gssName, Integer.MAX_VALUE, new Oid[]{krb5Oid, spnegoOid}, 2);
            GSSContext gContext = manager.createContext(serverCreds);
            if (gContext == null) {
                LOG.debug("SpnegoUserRealm: failed to establish GSSContext");
            } else {
                while (!gContext.isEstablished()) {
                    authToken = gContext.acceptSecContext(authToken, 0, authToken.length);
                }
                if (gContext.isEstablished()) {
                    String clientName = gContext.getSrcName().toString();
                    String role = clientName.substring(clientName.indexOf(64) + 1);
                    LOG.debug("SpnegoUserRealm: established a security context");
                    LOG.debug("Client Principal is: {}", (Object)gContext.getSrcName());
                    LOG.debug("Server Principal is: {}", (Object)gContext.getTargName());
                    LOG.debug("Client Default Role: {}", (Object)role);
                    SpnegoUserPrincipal user = new SpnegoUserPrincipal(clientName, authToken);
                    Subject subject = new Subject();
                    subject.getPrincipals().add((Principal)user);
                    return this._identityService.newUserIdentity(subject, (Principal)user, new String[]{role});
                }
            }
        }
        catch (GSSException gsse) {
            LOG.warn("Caught GSSException trying to authenticate the client", (Throwable)gsse);
        }
        return null;
    }
}

