/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.NotFound;
import org.apache.druid.indexing.compact.CompactionSupervisorSpec;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.security.AuthorizationUtils;
import org.joda.time.DateTime;

public class CompactionSupervisorManager {
    private final TaskMaster taskMaster;
    private final AuditManager auditManager;

    @Inject
    public CompactionSupervisorManager(TaskMaster taskMaster, AuditManager auditManager) {
        this.taskMaster = taskMaster;
        this.auditManager = auditManager;
    }

    public boolean updateCompactionSupervisor(CompactionSupervisorSpec spec, HttpServletRequest request) {
        return (Boolean)this.performIfLeader(manager -> {
            if (manager.shouldUpdateSupervisor(spec) && manager.createOrUpdateAndStartSupervisor(spec)) {
                String auditPayload = StringUtils.format((String)"Update supervisor[%s] for datasource[%s]", (Object[])new Object[]{spec.getId(), spec.getDataSources()});
                this.auditManager.doAudit(AuditEntry.builder().key(spec.getId()).type("supervisor").auditInfo(AuthorizationUtils.buildAuditInfo((HttpServletRequest)request)).request(AuthorizationUtils.buildRequestInfo((String)"overlord", (HttpServletRequest)request)).payload((Object)auditPayload).build());
            }
            return true;
        });
    }

    public CompactionSupervisorSpec getCompactionSupervisor(String dataSource) {
        String supervisorId = CompactionSupervisorSpec.getSupervisorIdForDatasource(dataSource);
        return (CompactionSupervisorSpec)this.performIfLeader(manager -> {
            Optional<SupervisorSpec> specOptional = manager.getSupervisorSpec(supervisorId);
            if (specOptional.isPresent()) {
                SupervisorSpec spec = (SupervisorSpec)specOptional.get();
                if (spec instanceof CompactionSupervisorSpec) {
                    return (CompactionSupervisorSpec)spec;
                }
                throw DruidException.defensive((String)"Supervisor for ID[%s] is of unexpected type[%s]", (Object[])new Object[]{supervisorId, spec.getClass().getSimpleName()});
            }
            throw NotFound.exception((String)"Compaction supervisor for datasource[%s] does not exist", (Object[])new Object[]{dataSource});
        });
    }

    public boolean deleteCompactionSupervisor(String dataSource) {
        String supervisorId = CompactionSupervisorSpec.getSupervisorIdForDatasource(dataSource);
        return (Boolean)this.performIfLeader(manager -> {
            if (manager.stopAndRemoveSupervisor(supervisorId)) {
                return true;
            }
            throw NotFound.exception((String)"Compaction supervisor for datasource[%s] does not exist", (Object[])new Object[]{dataSource});
        });
    }

    public List<CompactionSupervisorSpec> getAllCompactionSupervisors() {
        return (List)this.performIfLeader(manager -> {
            ArrayList<CompactionSupervisorSpec> compactionSpecs = new ArrayList<CompactionSupervisorSpec>();
            for (String supervisorId : Set.copyOf(manager.getSupervisorIds())) {
                SupervisorSpec supervisorSpec;
                Optional<SupervisorSpec> supervisorSpecOptional = manager.getSupervisorSpec(supervisorId);
                if (!supervisorSpecOptional.isPresent() || !((supervisorSpec = (SupervisorSpec)supervisorSpecOptional.get()) instanceof CompactionSupervisorSpec)) continue;
                compactionSpecs.add((CompactionSupervisorSpec)supervisorSpec);
            }
            return compactionSpecs;
        });
    }

    public List<DataSourceCompactionConfigAuditEntry> getCompactionSupervisorHistory(String dataSource) {
        String supervisorId = CompactionSupervisorSpec.getSupervisorIdForDatasource(dataSource);
        return (List)this.performIfLeader(manager -> manager.getSupervisorHistoryForId(supervisorId, null).stream().filter(versionedSpec -> versionedSpec.getSpec() instanceof CompactionSupervisorSpec).map(versionedSupervisorSpec -> new DataSourceCompactionConfigAuditEntry(null, ((CompactionSupervisorSpec)versionedSupervisorSpec.getSpec()).getSpec(), null, CompactionSupervisorManager.nullSafeDate(versionedSupervisorSpec.getVersion()))).collect(Collectors.toList()));
    }

    private <T> T performIfLeader(Function<SupervisorManager, T> managerFunction) {
        Optional<SupervisorManager> supervisorManager = this.taskMaster.getSupervisorManager();
        if (supervisorManager.isPresent()) {
            return (T)managerFunction.apply((Object)((SupervisorManager)supervisorManager.get()));
        }
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.SERVICE_UNAVAILABLE).build("Overlord is not leader", new Object[0]);
    }

    @Nullable
    private static DateTime nullSafeDate(String date) {
        return date == null || date.isEmpty() ? null : DateTimes.of((String)date);
    }
}

