/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics.serde;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.QuantilesSketchKeyCollectorSnapshot;
import org.apache.druid.msq.statistics.serde.KeyCollectorSnapshotSerializer;

public class QuantilesSnapshotSerializer
extends KeyCollectorSnapshotSerializer {
    public static final byte TYPE = 2;

    @Override
    protected byte getType() {
        return 2;
    }

    @Override
    protected byte[] serializeKeyCollector(KeyCollectorSnapshot collectorSnapshot) {
        QuantilesSketchKeyCollectorSnapshot quantileSnapshot = (QuantilesSketchKeyCollectorSnapshot)collectorSnapshot;
        double averageKeyLength = quantileSnapshot.getAverageKeyLength();
        byte[] sketch = StringUtils.decodeBase64String((String)quantileSnapshot.getEncodedSketch());
        return ByteBuffer.allocate(12 + sketch.length).putDouble(averageKeyLength).putInt(sketch.length).put(sketch).array();
    }
}

