/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;

public class InputSlices {
    private InputSlices() {
    }

    public static List<StageInputSlice> allStageSlices(List<InputSlice> slices) {
        ArrayList<StageInputSlice> retVal = new ArrayList<StageInputSlice>();
        for (InputSlice slice : slices) {
            if (!(slice instanceof StageInputSlice)) continue;
            retVal.add((StageInputSlice)slice);
        }
        return retVal;
    }

    public static ReadablePartitions allReadablePartitions(List<InputSlice> slices) {
        ArrayList<ReadablePartitions> partitionsList = new ArrayList<ReadablePartitions>();
        for (StageInputSlice slice : InputSlices.allStageSlices(slices)) {
            partitionsList.add(slice.getPartitions());
        }
        return ReadablePartitions.combine(partitionsList);
    }

    public static int getNumNonBroadcastReadableInputs(List<InputSlice> slices, InputSliceReader reader, IntSet broadcastInputs) {
        int numInputs = 0;
        for (int i = 0; i < slices.size(); ++i) {
            if (broadcastInputs.contains(i)) continue;
            numInputs += reader.numReadableInputs(slices.get(i));
        }
        return numInputs;
    }

    public static Int2ObjectMap<List<ReadableInput>> attachAndCollectPartitions(List<InputSlice> slices, InputSliceReader reader, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        ArrayList<Object> inputsByInputNumber = new ArrayList<Object>();
        for (InputSlice slice : slices) {
            if (slice instanceof NilInputSlice) {
                inputsByInputNumber.add(null);
                continue;
            }
            if (slice instanceof StageInputSlice) {
                ReadableInputs inputs = reader.attach(inputsByInputNumber.size(), slice, counters, warningPublisher);
                inputsByInputNumber.add(inputs);
                continue;
            }
            throw new ISE("Slice [%s] is not a 'stage' slice", new Object[]{slice});
        }
        Int2ObjectRBTreeMap retVal = new Int2ObjectRBTreeMap();
        for (int inputNumber = 0; inputNumber < slices.size(); ++inputNumber) {
            for (ReadableInput input : (ReadableInputs)inputsByInputNumber.get(inputNumber)) {
                if (input == null) continue;
                int partitionNumber = input.getStagePartition().getPartitionNumber();
                ((List)retVal.computeIfAbsent(partitionNumber, ignored -> Arrays.asList(new ReadableInput[slices.size()]))).set(inputNumber, input);
            }
        }
        for (Int2ObjectMap.Entry entry : retVal.int2ObjectEntrySet()) {
            for (int inputNumber = 0; inputNumber < ((List)entry.getValue()).size(); ++inputNumber) {
                if (((List)entry.getValue()).get(inputNumber) != null) continue;
                ((List)entry.getValue()).set(inputNumber, ReadableInput.channel((ReadableFrameChannel)ReadableNilFrameChannel.INSTANCE, ((ReadableInputs)inputsByInputNumber.get(inputNumber)).frameReader(), null));
            }
        }
        return retVal;
    }
}

