/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.druid.java.util.common.IAE;

public enum OutputChannelMode {
    MEMORY("memory"),
    LOCAL_STORAGE("localStorage"),
    DURABLE_STORAGE_INTERMEDIATE("durableStorage"),
    DURABLE_STORAGE_QUERY_RESULTS("durableStorageQueryResults");

    private final String name;

    private OutputChannelMode(String name) {
        this.name = name;
    }

    @JsonCreator
    public static OutputChannelMode fromString(String s) {
        for (OutputChannelMode mode : OutputChannelMode.values()) {
            if (!mode.toString().equals(s)) continue;
            return mode;
        }
        throw new IAE("No such outputChannelMode[%s]", new Object[]{s});
    }

    public boolean isDurable() {
        return this == DURABLE_STORAGE_INTERMEDIATE || this == DURABLE_STORAGE_QUERY_RESULTS;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

