/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import javax.inject.Inject;
import org.schemarepo.AbstractBackendRepository;
import org.schemarepo.InMemorySchemaEntryCache;
import org.schemarepo.RepositoryUtil;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.schemarepo.ValidatorFactory;

public class InMemoryRepository
extends AbstractBackendRepository {
    @Inject
    public InMemoryRepository(ValidatorFactory validators) {
        super(validators);
    }

    @Override
    protected Subject getSubjectInstance(String subjectName) {
        Subject subject = this.subjectCache.lookup(subjectName);
        if (subject == null) {
            throw new IllegalStateException("Unexpected: subject must've been cached by #registerSubjectInBackend");
        }
        return subject;
    }

    @Override
    protected void registerSubjectInBackend(String subjectName, SubjectConfig config) {
        this.cacheSubject(new MemSubject(subjectName, config));
    }

    private static class MemSubject
    extends Subject {
        private final InMemorySchemaEntryCache schemas = new InMemorySchemaEntryCache();
        private SchemaEntry latest = null;
        private int nextId = 0;
        private SubjectConfig config;

        protected MemSubject(String name, SubjectConfig config) {
            super(name);
            this.config = RepositoryUtil.safeConfig(config);
        }

        @Override
        public SubjectConfig getConfig() {
            return this.config;
        }

        @Override
        public synchronized SchemaEntry register(String schema) throws SchemaValidationException {
            SchemaEntry valueInCache;
            String id = String.valueOf(this.nextId);
            SchemaEntry toRegister = new SchemaEntry(id, schema);
            if (toRegister == (valueInCache = this.schemas.add(toRegister))) {
                ++this.nextId;
                this.latest = toRegister;
            }
            return valueInCache;
        }

        @Override
        public synchronized SchemaEntry registerIfLatest(String schema, SchemaEntry latest) throws SchemaValidationException {
            if (latest == this.latest || latest != null && latest.equals(this.latest)) {
                return this.register(schema);
            }
            return null;
        }

        @Override
        public SchemaEntry lookupBySchema(String schema) {
            return this.schemas.lookupBySchema(schema);
        }

        @Override
        public SchemaEntry lookupById(String id) {
            return this.schemas.lookupById(id);
        }

        @Override
        public synchronized SchemaEntry latest() {
            return this.latest;
        }

        @Override
        public synchronized Iterable<SchemaEntry> allEntries() {
            return this.schemas.values();
        }

        @Override
        public boolean integralKeys() {
            return true;
        }
    }
}

