/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.projections.ProjectionMatch;

public final class ProjectionMatchBuilder {
    private final Set<String> referencedPhysicalColumns = new HashSet<String>();
    private final Set<VirtualColumn> referencedVirtualColumns = new HashSet<VirtualColumn>();
    private final Map<String, String> remapColumns = new HashMap<String, String>();
    private final List<AggregatorFactory> combiningFactories = new ArrayList<AggregatorFactory>();
    @Nullable
    private Filter rewriteFilter;

    public ProjectionMatchBuilder remapColumn(String queryColumn, String projectionColumn) {
        this.remapColumns.put(queryColumn, projectionColumn);
        return this;
    }

    @Nullable
    public String getRemapValue(String queryColumn) {
        return this.remapColumns.get(queryColumn);
    }

    public ProjectionMatchBuilder addReferencedPhysicalColumn(String column) {
        this.referencedPhysicalColumns.add(column);
        return this;
    }

    public ProjectionMatchBuilder addReferenceedVirtualColumn(VirtualColumn virtualColumn) {
        this.referencedVirtualColumns.add(virtualColumn);
        return this;
    }

    public ProjectionMatchBuilder addPreAggregatedAggregator(AggregatorFactory aggregator) {
        this.combiningFactories.add(aggregator);
        return this;
    }

    public ProjectionMatchBuilder rewriteFilter(Filter rewriteFilter) {
        this.rewriteFilter = rewriteFilter;
        return this;
    }

    public Filter getRewriteFilter() {
        return this.rewriteFilter;
    }

    public Map<String, String> getRemapColumns() {
        return this.remapColumns;
    }

    public ProjectionMatch build(CursorBuildSpec queryCursorBuildSpec) {
        return new ProjectionMatch(CursorBuildSpec.builder(queryCursorBuildSpec).setFilter(this.rewriteFilter).setPhysicalColumns(this.referencedPhysicalColumns).setVirtualColumns(VirtualColumns.fromIterable(this.referencedVirtualColumns)).setAggregators(this.combiningFactories).build(), this.remapColumns);
    }
}

