/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.common.semantic.SemanticCreator;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.rowsandcols.EmptyRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.FrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.query.rowsandcols.semantic.DefaultRowsAndColumnsDecorator;
import org.apache.druid.query.rowsandcols.semantic.RowsAndColumnsDecorator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.joda.time.Interval;

public class LazilyDecoratedRowsAndColumns
implements RowsAndColumns {
    private static final Map<Class<?>, Function<LazilyDecoratedRowsAndColumns, ?>> AS_MAP = SemanticUtils.makeAsMap(LazilyDecoratedRowsAndColumns.class);
    private RowsAndColumns base;
    private Interval interval;
    private Filter filter;
    private VirtualColumns virtualColumns;
    private OffsetLimit limit;
    private LinkedHashSet<String> viewableColumns;
    private List<ColumnWithDirection> ordering;
    private final Integer allocatorCapacity;

    public LazilyDecoratedRowsAndColumns(RowsAndColumns base, Interval interval, Filter filter, VirtualColumns virtualColumns, OffsetLimit limit, List<ColumnWithDirection> ordering, LinkedHashSet<String> viewableColumns, Long allocatorCapacity) {
        this.base = base;
        this.interval = interval;
        this.filter = filter;
        this.virtualColumns = virtualColumns;
        this.limit = limit;
        this.ordering = ordering;
        this.viewableColumns = viewableColumns;
        this.allocatorCapacity = allocatorCapacity != null ? allocatorCapacity.intValue() : 0xC800000;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.viewableColumns == null ? this.base.getColumnNames() : this.viewableColumns;
    }

    public RowsAndColumns getBase() {
        return this.base;
    }

    @Override
    public int numRows() {
        this.maybeMaterialize();
        return this.base.numRows();
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (this.viewableColumns != null && !this.viewableColumns.contains(name)) {
            return null;
        }
        this.maybeMaterialize();
        return this.base.findColumn(name);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        return (T)AS_MAP.getOrDefault(clazz, arg -> null).apply(this);
    }

    @SemanticCreator
    public RowsAndColumnsDecorator toRowsAndColumnsDecorator() {
        if (this.viewableColumns == null || this.viewableColumns.isEmpty()) {
            return new DefaultRowsAndColumnsDecorator(this.base, this.interval, this.filter, this.virtualColumns, this.limit, this.ordering);
        }
        return new DefaultRowsAndColumnsDecorator(this);
    }

    @SemanticCreator
    public FrameRowsAndColumns toFrameRowsAndColumns() {
        this.maybeMaterialize();
        return this.base.as(FrameRowsAndColumns.class);
    }

    private void maybeMaterialize() {
        if (this.needsMaterialization()) {
            Pair<byte[], RowSignature> thePair = this.materialize();
            if (thePair == null) {
                this.reset(new EmptyRowsAndColumns());
            } else {
                this.reset(new ColumnBasedFrameRowsAndColumns(Frame.wrap((byte[])thePair.lhs), (RowSignature)thePair.rhs));
            }
        }
    }

    private boolean needsMaterialization() {
        return this.interval != null || this.filter != null || this.limit.isPresent() || this.ordering != null || this.virtualColumns != null;
    }

    private Pair<byte[], RowSignature> materialize() {
        if (this.ordering != null) {
            throw new ISE("Cannot reorder[%s] scan data right now", this.ordering);
        }
        CursorFactory as = this.base.as(CursorFactory.class);
        if (as == null) {
            return this.naiveMaterialize(this.base);
        }
        return this.materializeCursorFactory(as);
    }

    private void reset(RowsAndColumns rac) {
        this.base = rac;
        this.interval = null;
        this.filter = null;
        this.virtualColumns = null;
        this.limit = OffsetLimit.NONE;
        this.viewableColumns = null;
        this.ordering = null;
    }

    @Nullable
    private Pair<byte[], RowSignature> materializeCursorFactory(CursorFactory cursorFactory) {
        Object cols = this.viewableColumns != null ? this.viewableColumns : (this.virtualColumns == null ? this.base.getColumnNames() : ImmutableList.builder().addAll(this.base.getColumnNames()).addAll(this.virtualColumns.getColumnNames()).build());
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setFilter(this.filter);
        if (this.interval != null) {
            builder.setInterval(this.interval);
        }
        if (this.virtualColumns != null) {
            builder.setVirtualColumns(this.virtualColumns);
        }
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(builder.build());){
            KeyOrder order;
            Cursor cursor = cursorHolder.asCursor();
            if (cursor == null) {
                Pair<byte[], RowSignature> pair = null;
                return pair;
            }
            AtomicReference<Object> siggy = new AtomicReference<Object>(null);
            long remainingRowsToSkip = this.limit.getOffset();
            long remainingRowsToFetch = this.limit.getLimitOrMax();
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            RowSignature.Builder sigBob = RowSignature.builder();
            for (String col : cols) {
                ColumnCapabilities capabilities = this.virtualColumns != null ? this.virtualColumns.getColumnCapabilitiesWithFallback(columnSelectorFactory, col) : columnSelectorFactory.getColumnCapabilities(col);
                if (capabilities == null) continue;
                sigBob.add(col, capabilities.toColumnType());
            }
            RowSignature signature = sigBob.build();
            siggy.set(signature);
            ArrayList<KeyColumn> sortColumns = new ArrayList<KeyColumn>();
            if (this.ordering != null) {
                for (ColumnWithDirection columnWithDirection : this.ordering) {
                    order = columnWithDirection.getDirection() == ColumnWithDirection.Direction.DESC ? KeyOrder.DESCENDING : KeyOrder.ASCENDING;
                    sortColumns.add(new KeyColumn(columnWithDirection.getColumn(), order));
                }
            }
            FrameWriterFactory frameWriterFactory = FrameWriters.makeColumnBasedFrameWriterFactory(new ArenaMemoryAllocatorFactory(this.allocatorCapacity), signature, sortColumns);
            FrameWriter writer = frameWriterFactory.newFrameWriter(columnSelectorFactory);
            while (!cursor.isDoneOrInterrupted() && remainingRowsToSkip > 0L) {
                cursor.advance();
                --remainingRowsToSkip;
            }
            while (!cursor.isDoneOrInterrupted() && remainingRowsToFetch > 0L) {
                writer.addSelection();
                cursor.advance();
                --remainingRowsToFetch;
            }
            if (writer == null) {
                order = null;
                return order;
            }
            byte[] bytes = writer.toByteArray();
            Pair<byte[], RowSignature> pair = Pair.of(bytes, siggy.get());
            return pair;
        }
    }

    @Nullable
    private Pair<byte[], RowSignature> naiveMaterialize(RowsAndColumns rac) {
        int numRows = rac.numRows();
        BitSet rowsToSkip = null;
        if (this.interval != null) {
            rowsToSkip = new BitSet(numRows);
            Column racColumn = rac.findColumn("__time");
            if (racColumn == null) {
                if (!this.interval.contains(0L)) {
                    return null;
                }
            } else {
                ColumnAccessor accessor = racColumn.toAccessor();
                for (int i = 0; i < accessor.numRows(); ++i) {
                    rowsToSkip.set(i, !this.interval.contains(accessor.getLong(i)));
                }
            }
        }
        AtomicInteger rowId = new AtomicInteger(0);
        ColumnSelectorFactoryMaker csfm = ColumnSelectorFactoryMaker.fromRAC(rac);
        ColumnSelectorFactory selectorFactory = csfm.make(rowId);
        if (this.filter != null) {
            if (rowsToSkip == null) {
                rowsToSkip = new BitSet(numRows);
            }
            ValueMatcher matcher = this.filter.makeMatcher(selectorFactory);
            while (rowId.get() < numRows) {
                int theId = rowId.get();
                if (!rowsToSkip.get(theId) && !matcher.matches(false)) {
                    rowsToSkip.set(theId);
                }
                rowId.incrementAndGet();
            }
        }
        if (this.virtualColumns != null) {
            throw new UOE("Cannot apply virtual columns [%s] with naive apply.", this.virtualColumns);
        }
        ArrayList<String> columnsToGenerate = new ArrayList<String>();
        if (this.viewableColumns != null) {
            columnsToGenerate.addAll(this.viewableColumns);
        } else {
            columnsToGenerate.addAll(rac.getColumnNames());
        }
        RowSignature.Builder sigBob = RowSignature.builder();
        ArenaMemoryAllocatorFactory memFactory = new ArenaMemoryAllocatorFactory(this.allocatorCapacity);
        for (String column : columnsToGenerate) {
            Column racColumn = rac.findColumn(column);
            if (racColumn == null) continue;
            sigBob.add(column, racColumn.toAccessor().getType());
        }
        long remainingRowsToSkip = this.limit.getOffset();
        long remainingRowsToFetch = this.limit.getLimitOrMax();
        FrameWriter frameWriter = FrameWriters.makeColumnBasedFrameWriterFactory(memFactory, sigBob.build(), Collections.emptyList()).newFrameWriter(selectorFactory);
        rowId.set(0);
        while (rowId.get() < numRows && remainingRowsToFetch > 0L) {
            int theId = rowId.get();
            if (rowsToSkip == null || !rowsToSkip.get(theId)) {
                if (remainingRowsToSkip > 0L) {
                    --remainingRowsToSkip;
                } else {
                    --remainingRowsToFetch;
                    frameWriter.addSelection();
                }
            }
            rowId.incrementAndGet();
        }
        return Pair.of(frameWriter.toByteArray(), sigBob.build());
    }
}

