/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import java.io.Closeable;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.java.util.common.ISE;

public class LongFrameMaker
implements Closeable {
    public static final long DATA_OFFSET = 2L;
    private final AppendableMemory appendableMemory;
    private final boolean hasNulls;
    private final int sz;

    public LongFrameMaker(MemoryAllocator allocator, boolean hasNulls) {
        this.appendableMemory = AppendableMemory.create(allocator);
        this.hasNulls = hasNulls;
        this.sz = LongFrameMaker.valueSize(hasNulls);
    }

    public static int valueSize(boolean hasNulls) {
        return hasNulls ? 9 : 8;
    }

    public boolean add(long value) {
        if (!this.appendableMemory.reserveAdditional(this.sz)) {
            return false;
        }
        MemoryRange<WritableMemory> cursor = this.appendableMemory.cursor();
        WritableMemory memory = cursor.memory();
        long position = cursor.start();
        if (this.hasNulls) {
            memory.putByte(position, (byte)0);
            memory.putLong(position + 1L, value);
        } else {
            memory.putLong(position, value);
        }
        this.appendableMemory.advanceCursor(this.sz);
        return true;
    }

    public boolean addNull() {
        if (!this.hasNulls) {
            throw new ISE("Was told that null doesn't exist, cannot add null", new Object[0]);
        }
        if (!this.appendableMemory.reserveAdditional(this.sz)) {
            return false;
        }
        MemoryRange<WritableMemory> cursor = this.appendableMemory.cursor();
        WritableMemory memory = cursor.memory();
        long position = cursor.start();
        memory.putByte(position, (byte)1);
        memory.putLong(position + 1L, 0L);
        this.appendableMemory.advanceCursor(this.sz);
        return true;
    }

    public void undo() {
        this.appendableMemory.rewindCursor(this.sz);
    }

    public long size() {
        return 2L + this.appendableMemory.size();
    }

    public long writeTo(WritableMemory memory, long startPosition) {
        long currentPosition = startPosition;
        memory.putByte(currentPosition, (byte)1);
        memory.putByte(currentPosition + 1L, this.hasNulls ? (byte)1 : 0);
        currentPosition += 2L;
        currentPosition += this.appendableMemory.writeTo(memory, currentPosition);
        return currentPosition - startPosition;
    }

    @Override
    public void close() {
        this.appendableMemory.close();
    }
}

