/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.columnar;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.segment.FrameFilteredOffset;
import org.apache.druid.frame.segment.columnar.FrameQueryableIndex;
import org.apache.druid.frame.segment.columnar.FrameVectorCursor;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.vector.FilteredVectorOffset;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.QueryableIndexVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.utils.CloseableUtils;

public class ColumnarFrameCursorFactory
implements CursorFactory {
    private final Frame frame;
    private final RowSignature signature;
    private final List<FrameColumnReader> columnReaders;

    public ColumnarFrameCursorFactory(Frame frame, RowSignature signature, List<FrameColumnReader> columnReaders) {
        this.frame = frame.ensureColumnar();
        this.signature = signature;
        this.columnReaders = columnReaders;
    }

    @Override
    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        return new ColumnarFrameCursorHolder(spec);
    }

    @Override
    public RowSignature getRowSignature() {
        return this.signature;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        int columnNumber = this.signature.indexOf(column);
        if (columnNumber < 0) {
            return null;
        }
        return this.columnReaders.get(columnNumber).readColumn(this.frame).getCapabilities();
    }

    private class ColumnarFrameCursorHolder
    implements CursorHolder {
        private final CursorBuildSpec spec;
        private final Closer closer = Closer.create();
        private final List<OrderBy> ordering = Collections.emptyList();

        private ColumnarFrameCursorHolder(CursorBuildSpec spec) {
            this.spec = spec;
        }

        @Override
        public boolean canVectorize() {
            List<AggregatorFactory> aggregatorFactories = this.spec.getAggregators();
            VirtualColumns virtualColumns = this.spec.getVirtualColumns();
            Filter filter = this.spec.getFilter();
            QueryContext queryContext = this.spec.getQueryContext();
            ColumnInspector inspector = virtualColumns.wrapInspector(ColumnarFrameCursorFactory.this);
            if (!virtualColumns.isEmpty() && !queryContext.getVectorizeVirtualColumns().shouldVectorize(virtualColumns.canVectorize(inspector))) {
                return false;
            }
            if (aggregatorFactories != null) {
                for (AggregatorFactory factory : aggregatorFactories) {
                    if (factory.canVectorize(inspector)) continue;
                    return false;
                }
            }
            return filter == null || filter.canVectorizeMatcher(inspector);
        }

        @Override
        public Cursor asCursor() {
            FrameQueryableIndex index = new FrameQueryableIndex(ColumnarFrameCursorFactory.this.frame, ColumnarFrameCursorFactory.this.signature, ColumnarFrameCursorFactory.this.columnReaders);
            ColumnCache columnCache = new ColumnCache(index, this.spec.getVirtualColumns(), this.closer);
            Filter filterToUse = FrameCursorUtils.buildFilter(this.spec.getFilter(), this.spec.getInterval());
            SimpleAscendingOffset baseOffset = new SimpleAscendingOffset(ColumnarFrameCursorFactory.this.frame.numRows());
            QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(this.spec.getVirtualColumns(), Order.NONE, baseOffset, columnCache);
            SimpleSettableOffset offset = filterToUse == null ? baseOffset : new FrameFilteredOffset(baseOffset, columnSelectorFactory, filterToUse);
            return new FrameCursor(offset, columnSelectorFactory);
        }

        @Override
        public List<OrderBy> getOrdering() {
            return this.ordering;
        }

        @Override
        @Nullable
        public VectorCursor asVectorCursor() {
            if (!this.canVectorize()) {
                throw new ISE("Cannot vectorize. Check 'canVectorize' before calling 'asVectorCursor'.", new Object[0]);
            }
            FrameQueryableIndex index = new FrameQueryableIndex(ColumnarFrameCursorFactory.this.frame, ColumnarFrameCursorFactory.this.signature, ColumnarFrameCursorFactory.this.columnReaders);
            Filter filterToUse = FrameCursorUtils.buildFilter(this.spec.getFilter(), this.spec.getInterval());
            NoFilterVectorOffset baseOffset = new NoFilterVectorOffset(this.spec.getQueryContext().getVectorSize(), 0, ColumnarFrameCursorFactory.this.frame.numRows());
            ColumnCache columnCache = new ColumnCache(index, this.spec.getVirtualColumns(), this.closer);
            QueryableIndexVectorColumnSelectorFactory baseSelectorFactory = new QueryableIndexVectorColumnSelectorFactory(baseOffset, columnCache, this.spec.getVirtualColumns());
            if (filterToUse == null) {
                return new FrameVectorCursor(baseOffset, baseSelectorFactory);
            }
            VectorValueMatcher matcher = filterToUse.makeVectorMatcher(baseSelectorFactory);
            FilteredVectorOffset filteredOffset = FilteredVectorOffset.create(baseOffset, matcher);
            QueryableIndexVectorColumnSelectorFactory filteredSelectorFactory = new QueryableIndexVectorColumnSelectorFactory(filteredOffset, columnCache, this.spec.getVirtualColumns());
            return new FrameVectorCursor(filteredOffset, filteredSelectorFactory);
        }

        @Override
        public void close() {
            CloseableUtils.closeAndWrapExceptions(this.closer);
        }
    }
}

