/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.FrameComparisonWidgetImpl;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReaders;
import org.apache.druid.frame.segment.columnar.ColumnarFrameCursorFactory;
import org.apache.druid.frame.segment.row.RowFrameCursorFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameReader {
    private final RowSignature signature;
    private volatile List<FrameColumnReader> columnReaders;
    @GuardedBy(value="fieldReaders")
    private final EnumMap<FrameType, List<FieldReader>> fieldReaders = new EnumMap(FrameType.class);

    private FrameReader(RowSignature signature) {
        this.signature = signature;
    }

    public static FrameReader create(RowSignature signature) {
        Set<String> disallowedFieldNames = FrameWriterUtils.findDisallowedFieldNames(signature);
        if (!disallowedFieldNames.isEmpty()) {
            throw new IAE("Disallowed column names[%s]", disallowedFieldNames);
        }
        for (int columnNumber = 0; columnNumber < signature.size(); ++columnNumber) {
            if (signature.getColumnType(columnNumber).isPresent()) continue;
            throw DruidException.defensive("Missing type for column[%s]", signature.getColumnName(columnNumber));
        }
        return new FrameReader(signature);
    }

    public RowSignature signature() {
        return this.signature;
    }

    @Nullable
    public ColumnCapabilities columnCapabilities(Frame frame, String columnName) {
        int columnNumber = this.signature.indexOf(columnName);
        if (columnNumber < 0) {
            return null;
        }
        if (frame.type().isColumnar()) {
            return this.getColumnReaders().get(columnNumber).readColumn(frame).getCapabilities();
        }
        return this.signature.getColumnCapabilities(columnName);
    }

    public CursorFactory makeCursorFactory(Frame frame) {
        if (frame.type().isColumnar()) {
            return new ColumnarFrameCursorFactory(frame, this.signature, this.getColumnReaders());
        }
        return new RowFrameCursorFactory(frame, this, this.getFieldReaders(frame.type()));
    }

    public FrameComparisonWidget makeComparisonWidget(Frame frame, List<KeyColumn> keyColumns) {
        FrameWriterUtils.verifySortColumns(keyColumns, this.signature);
        return FrameComparisonWidgetImpl.create(frame, this.signature, keyColumns, this.getFieldReaders(frame.type()).subList(0, keyColumns.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FrameColumnReader> getColumnReaders() {
        if (this.columnReaders == null) {
            FrameReader frameReader = this;
            synchronized (frameReader) {
                if (this.columnReaders == null) {
                    this.columnReaders = FrameReader.makeColumnReaders(this.signature);
                }
            }
        }
        return this.columnReaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FieldReader> getFieldReaders(FrameType frameType) {
        EnumMap<FrameType, List<FieldReader>> enumMap = this.fieldReaders;
        synchronized (enumMap) {
            return this.fieldReaders.computeIfAbsent(frameType, type -> FrameReader.makeFieldReaders(this.signature, type));
        }
    }

    private static List<FrameColumnReader> makeColumnReaders(RowSignature signature) {
        ArrayList<FrameColumnReader> columnReaders = new ArrayList<FrameColumnReader>(signature.size());
        for (int columnNumber = 0; columnNumber < signature.size(); ++columnNumber) {
            ColumnType columnType = signature.getColumnType(columnNumber).get();
            columnReaders.add(FrameColumnReaders.create(signature.getColumnName(columnNumber), columnNumber, columnType));
        }
        return columnReaders;
    }

    private static List<FieldReader> makeFieldReaders(RowSignature signature, FrameType frameType) {
        ArrayList<FieldReader> fieldReaders = new ArrayList<FieldReader>(signature.size());
        for (int columnNumber = 0; columnNumber < signature.size(); ++columnNumber) {
            ColumnType columnType = signature.getColumnType(columnNumber).get();
            fieldReaders.add(FieldReaders.create(signature.getColumnName(columnNumber), columnType, frameType));
        }
        return fieldReaders;
    }
}

