/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.TaskDirectory;
import org.apache.druid.segment.realtime.appenderator.TaskIntervalUnlocker;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.joda.time.Interval;

public class PeonAppenderatorsManager
implements AppenderatorsManager {
    private Appenderator realtimeAppenderator;
    private Appenderator batchAppenderator;

    @Override
    public Appenderator createRealtimeAppenderatorForTask(SegmentLoaderConfig segmentLoaderConfig, String taskId, DataSchema schema, AppenderatorConfig config, TaskDirectory taskDirectory, SegmentGenerationMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper jsonMapper, IndexIO indexIO, IndexMerger indexMerger, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, JoinableFactory joinableFactory, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, PolicyEnforcer policyEnforcer, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig, TaskIntervalUnlocker taskIntervalUnlocker) {
        if (this.realtimeAppenderator != null) {
            throw new ISE("A realtime appenderator was already created for this peon's task.", new Object[0]);
        }
        if (this.batchAppenderator != null) {
            throw new ISE("A batch appenderator was already created for this peon's task.", new Object[0]);
        }
        this.realtimeAppenderator = Appenderators.createRealtime(segmentLoaderConfig, taskId, schema, config, metrics, dataSegmentPusher, jsonMapper, indexIO, indexMerger, conglomerate, segmentAnnouncer, emitter, queryProcessingPool, cache, cacheConfig, cachePopulatorStats, policyEnforcer, rowIngestionMeters, parseExceptionHandler, centralizedDatasourceSchemaConfig, taskIntervalUnlocker);
        return this.realtimeAppenderator;
    }

    @Override
    public Appenderator createBatchAppenderatorForTask(String taskId, DataSchema schema, AppenderatorConfig config, TaskDirectory taskDirectory, SegmentGenerationMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, IndexIO indexIO, IndexMerger indexMerger, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        if (this.realtimeAppenderator != null) {
            throw new ISE("A realtime appenderator was already created for this peon's task.", new Object[0]);
        }
        this.batchAppenderator = Appenderators.createBatch(taskId, schema, config, metrics, dataSegmentPusher, objectMapper, indexIO, indexMerger, rowIngestionMeters, parseExceptionHandler, centralizedDatasourceSchemaConfig);
        return this.batchAppenderator;
    }

    @Override
    public void removeAppenderatorsForTask(String taskId, String dataSource) {
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        if (this.realtimeAppenderator == null) {
            throw new ISE("Was asked for a query runner but realtimeAppenderator was null!", new Object[0]);
        }
        return this.realtimeAppenderator.getQueryRunnerForIntervals(query, intervals);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        if (this.realtimeAppenderator == null) {
            throw new ISE("Was asked for a query runner but realtimeAppenderator was null!", new Object[0]);
        }
        return this.realtimeAppenderator.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public boolean shouldTaskMakeNodeAnnouncements() {
        return true;
    }

    @Override
    public void shutdown() {
    }
}

