/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.Atomic;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.Store;

public final class Queues {
    private Queues() {
    }

    public static class CircularQueue<E>
    extends SimpleQueue<E> {
        protected final Atomic.Long headInsert;
        protected final Lock lock = new ReentrantLock(false);
        protected final long size;

        public CircularQueue(Engine engine, Serializer<E> serializer, long headRecid, long headInsertRecid, long size) {
            super(engine, serializer, headRecid, false);
            this.headInsert = new Atomic.Long(engine, headInsertRecid);
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Object o) {
            this.lock.lock();
            try {
                long nRecid = this.headInsert.get();
                SimpleQueue.Node<Object> n = (SimpleQueue.Node<Object>)this.engine.get(nRecid, this.nodeSerializer);
                n = new SimpleQueue.Node<Object>(n.next, o);
                this.engine.update(nRecid, n, this.nodeSerializer);
                this.headInsert.set(n.next);
                this.head.compareAndSet(nRecid, n.next);
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.lock.lock();
            try {
                int i = 0;
                while ((long)i < this.size) {
                    this.poll();
                    ++i;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E poll() {
            this.lock.lock();
            try {
                long nRecid = this.head.get();
                SimpleQueue.Node n = (SimpleQueue.Node)this.engine.get(nRecid, this.nodeSerializer);
                this.engine.update(nRecid, new SimpleQueue.Node<Object>(n.next, null), this.nodeSerializer);
                this.head.set(n.next);
                Object e = n.value;
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E peek() {
            this.lock.lock();
            try {
                long nRecid = this.head.get();
                SimpleQueue.Node n = (SimpleQueue.Node)this.engine.get(nRecid, this.nodeSerializer);
                Object e = n.value;
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class Queue<E>
    extends SimpleQueue<E> {
        protected final Atomic.Long tail;

        public Queue(Engine engine, Serializer<E> serializer, long headerRecid, long nextTailRecid, boolean useLocks) {
            super(engine, serializer, headerRecid, useLocks);
            this.tail = new Atomic.Long(engine, nextTailRecid);
        }

        @Override
        public boolean add(E e) {
            long nextTail = this.engine.put(SimpleQueue.Node.EMPTY, this.nodeSerializer);
            long tail2 = this.tail.get();
            while (!this.tail.compareAndSet(tail2, nextTail)) {
                tail2 = this.tail.get();
            }
            SimpleQueue.Node<E> n = new SimpleQueue.Node<E>(nextTail, e);
            this.engine.update(tail2, n, this.nodeSerializer);
            return true;
        }
    }

    public static class Stack<E>
    extends SimpleQueue<E> {
        public Stack(Engine engine, Serializer<E> serializer, long headerRecidRef, boolean useLocks) {
            super(engine, serializer, headerRecidRef, useLocks);
        }

        @Override
        public boolean add(E e) {
            long head2 = this.head.get();
            SimpleQueue.Node<E> n = new SimpleQueue.Node<E>(head2, e);
            long recid = this.engine.put(n, this.nodeSerializer);
            while (!this.head.compareAndSet(head2, recid)) {
                head2 = this.head.get();
                n = new SimpleQueue.Node<E>(head2, e);
                this.engine.update(recid, n, this.nodeSerializer);
            }
            return true;
        }
    }

    public static abstract class SimpleQueue<E>
    implements BlockingQueue<E> {
        protected final boolean useLocks;
        protected final ReentrantLock[] locks;
        protected static final int TICK = 10000;
        protected final Engine engine;
        protected final Serializer<E> serializer;
        protected final Atomic.Long head;
        protected final Serializer<Node<E>> nodeSerializer;

        public SimpleQueue(Engine engine, Serializer<E> serializer, long headRecidRef, boolean useLocks) {
            this.engine = engine;
            this.serializer = serializer;
            this.head = new Atomic.Long(engine, headRecidRef);
            this.nodeSerializer = new NodeSerializer<E>(serializer);
            this.useLocks = useLocks;
            if (useLocks) {
                this.locks = new ReentrantLock[128];
                for (int i = 0; i < this.locks.length; ++i) {
                    this.locks[i] = new ReentrantLock(false);
                }
            } else {
                this.locks = null;
            }
        }

        public void close() {
            this.engine.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E peek() {
            long head2 = this.head.get();
            if (this.useLocks) {
                this.locks[Store.lockPos(head2)].lock();
            }
            try {
                Node<E> n = this.engine.get(head2, this.nodeSerializer);
                if (n == Node.EMPTY) {
                    E e = null;
                    return e;
                }
                Object e = n.value;
                return e;
            }
            finally {
                if (this.useLocks) {
                    this.locks[Store.lockPos(head2)].unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E poll() {
            while (true) {
                long head2 = this.head.get();
                if (this.useLocks) {
                    this.locks[Store.lockPos(head2)].lock();
                }
                try {
                    Node<E> n = this.engine.get(head2, this.nodeSerializer);
                    if (n == Node.EMPTY) {
                        E e = null;
                        return e;
                    }
                    if (!this.head.compareAndSet(head2, n.next)) continue;
                    if (this.useLocks) {
                        this.engine.delete(head2, this.nodeSerializer);
                    } else {
                        this.engine.update(head2, Node.EMPTY, this.nodeSerializer);
                    }
                    Object e = n.value;
                    return e;
                }
                finally {
                    if (!this.useLocks) continue;
                    this.locks[Store.lockPos(head2)].unlock();
                    continue;
                }
                break;
            }
        }

        @Override
        public void clear() {
            while (!this.isEmpty()) {
                this.poll();
            }
        }

        @Override
        public E remove() {
            E ret = this.poll();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public E element() {
            E ret = this.peek();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public boolean offer(E e) {
            try {
                return this.add(e);
            }
            catch (IllegalStateException ee) {
                return false;
            }
        }

        @Override
        public void put(E e) throws InterruptedException {
            while (!this.offer(e)) {
                Thread.sleep(0L, 10000);
            }
        }

        @Override
        public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
            if (this.offer(e)) {
                return true;
            }
            long target = System.currentTimeMillis() + unit.toMillis(timeout);
            while (target >= System.currentTimeMillis()) {
                if (this.offer(e)) {
                    return true;
                }
                Thread.sleep(0L, 10000);
            }
            return false;
        }

        @Override
        public E take() throws InterruptedException {
            E e = this.poll();
            while (e == null) {
                Thread.sleep(0L, 10000);
                e = this.poll();
            }
            return e;
        }

        @Override
        public E poll(long timeout, TimeUnit unit) throws InterruptedException {
            E e = this.poll();
            if (e != null) {
                return e;
            }
            long target = System.currentTimeMillis() + unit.toMillis(timeout);
            while (target >= System.currentTimeMillis()) {
                Thread.sleep(0L, 10000);
                e = this.poll();
                if (e == null) continue;
                return e;
            }
            return null;
        }

        @Override
        public int drainTo(Collection<? super E> c) {
            return this.drainTo(c, Integer.MAX_VALUE);
        }

        @Override
        public int drainTo(Collection<? super E> c, int maxElements) {
            int counter;
            for (counter = 0; counter < maxElements; ++counter) {
                E e = this.poll();
                if (e == null) {
                    return counter;
                }
                c.add(e);
            }
            return counter;
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isEmpty() {
            return this.peek() == null;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        protected static final class Node<E> {
            protected static final Node<?> EMPTY = new Node<Object>(0L, null);
            protected final long next;
            protected final E value;

            public Node(long next, E value) {
                this.next = next;
                this.value = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Node node = (Node)o;
                if (this.next != node.next) {
                    return false;
                }
                return !(this.value != null ? !this.value.equals(node.value) : node.value != null);
            }

            public int hashCode() {
                int result = (int)(this.next ^ this.next >>> 32);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }

        protected static class NodeSerializer<E>
        implements Serializer<Node<E>> {
            private final Serializer<E> serializer;

            public NodeSerializer(Serializer<E> serializer) {
                this.serializer = serializer;
            }

            @Override
            public void serialize(DataOutput out, Node<E> value) throws IOException {
                if (value == Node.EMPTY) {
                    return;
                }
                DataOutput2.packLong(out, value.next);
                this.serializer.serialize(out, value.value);
            }

            @Override
            public Node<E> deserialize(DataInput in, int available) throws IOException {
                if (available == 0) {
                    return Node.EMPTY;
                }
                return new Node<E>(DataInput2.unpackLong(in), this.serializer.deserialize(in, -1));
            }

            @Override
            public int fixedSize() {
                return -1;
            }
        }
    }
}

