/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.tdml.DFDLTestSuite;
import org.apache.daffodil.tdml.ExpectedErrors;
import org.apache.daffodil.tdml.ExpectedValidationErrors;
import org.apache.daffodil.tdml.ExpectedWarnings;
import org.apache.daffodil.tdml.Infoset;
import org.apache.daffodil.tdml.OnePassRoundTrip$;
import org.apache.daffodil.tdml.RoundTrip;
import org.apache.daffodil.tdml.TDMLDiagnostic;
import org.apache.daffodil.tdml.TDMLException;
import org.apache.daffodil.tdml.TDMLException$;
import org.apache.daffodil.tdml.TestCase;
import org.apache.daffodil.tdml.TwoPassRoundTrip$;
import org.apache.daffodil.tdml.UnparserTestCase$;
import org.apache.daffodil.tdml.VerifyTestCase$;
import org.apache.daffodil.tdml.processor.TDMLDFDLProcessor;
import org.apache.daffodil.tdml.processor.TDMLParseResult;
import org.apache.daffodil.tdml.processor.TDMLUnparseResult;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;

public class UnparserTestCase
extends TestCase
implements Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(UnparserTestCase.class.getDeclaredField("inputInfoset$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UnparserTestCase.class.getDeclaredField("optInputInfoset$lzy1"));
    private final NodeSeq ptc;
    private final DFDLTestSuite parentArg;
    private volatile Object optInputInfoset$lzy1;
    private volatile Object inputInfoset$lzy1;

    public static UnparserTestCase apply(NodeSeq nodeSeq, DFDLTestSuite dFDLTestSuite) {
        return UnparserTestCase$.MODULE$.apply(nodeSeq, dFDLTestSuite);
    }

    public static UnparserTestCase fromProduct(Product product) {
        return UnparserTestCase$.MODULE$.fromProduct(product);
    }

    public static UnparserTestCase unapply(UnparserTestCase unparserTestCase) {
        return UnparserTestCase$.MODULE$.unapply(unparserTestCase);
    }

    public UnparserTestCase(NodeSeq ptc, DFDLTestSuite parentArg) {
        this.ptc = ptc;
        this.parentArg = parentArg;
        super(ptc, parentArg);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 883187087, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof UnparserTestCase)) return false;
        UnparserTestCase unparserTestCase = (UnparserTestCase)object;
        NodeSeq nodeSeq = this.ptc();
        NodeSeq nodeSeq2 = unparserTestCase.ptc();
        if (nodeSeq == null) {
            if (nodeSeq2 != null) {
                return false;
            }
        } else if (!nodeSeq.equals(nodeSeq2)) return false;
        DFDLTestSuite dFDLTestSuite = this.parentArg();
        DFDLTestSuite dFDLTestSuite2 = unparserTestCase.parentArg();
        if (dFDLTestSuite == null) {
            if (dFDLTestSuite2 != null) {
                return false;
            }
        } else if (!dFDLTestSuite.equals(dFDLTestSuite2)) return false;
        if (!unparserTestCase.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof UnparserTestCase;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "UnparserTestCase";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "ptc";
        }
        if (1 == n2) {
            return "parentArg";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public NodeSeq ptc() {
        return this.ptc;
    }

    public DFDLTestSuite parentArg() {
        return this.parentArg;
    }

    public Option<Infoset> optInputInfoset() {
        Object object = this.optInputInfoset$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.optInputInfoset$lzyINIT1();
    }

    private Object optInputInfoset$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.optInputInfoset$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Option<Infoset> option = null;
                    Option<Infoset> option2 = null;
                    try {
                        option2 = this.optExpectedOrInputInfoset();
                        option = option2 == null ? LazyVals.NullValue$.MODULE$ : option2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, option)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.optInputInfoset$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, option);
                            waiting.countDown();
                        }
                    }
                    return option2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Infoset inputInfoset() {
        Object object = this.inputInfoset$lzy1;
        if (object instanceof Infoset) {
            return (Infoset)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Infoset)this.inputInfoset$lzyINIT1();
    }

    private Object inputInfoset$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.inputInfoset$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Infoset infoset = null;
                    try {
                        infoset = (Infoset)this.optInputInfoset().get();
                        object2 = infoset == null ? LazyVals.NullValue$.MODULE$ : infoset;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.inputInfoset$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return infoset;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void runProcessor(Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> compileResult, Option<InputStream> optExpectedData, Option<Object> optNBits, Option<Seq<ExpectedErrors>> optErrors, Option<Seq<ExpectedWarnings>> optWarnings, Option<Seq<ExpectedValidationErrors>> optValidationErrors, RoundTrip roundTrip, Option<String> implString) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(optExpectedData, optErrors);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                InputStream expectedData = (InputStream)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    Tuple2 tuple22;
                    Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> either = compileResult;
                    if (either instanceof Left) {
                        List diags = (List)((Left)either).value();
                        throw TDMLException$.MODULE$.apply((Iterable<Throwable>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala(), implString);
                    }
                    if (either instanceof Right && (tuple22 = (Tuple2)((Right)either).value()) != null) {
                        List diags = (List)tuple22._1();
                        TDMLDFDLProcessor proc = (TDMLDFDLProcessor)tuple22._2();
                        this.processor_$eq(proc);
                        this.runUnparserExpectSuccess(expectedData, optWarnings, optValidationErrors, roundTrip, implString, (Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala());
                        return;
                    }
                    throw new MatchError(either);
                }
            }
            if (option2 instanceof Some) {
                Tuple2 tuple23;
                Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> either = compileResult;
                if (either instanceof Left) {
                    List diags = (List)((Left)either).value();
                    this.checkDiagnosticMessages((Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala(), optErrors, optWarnings, optValidationErrors, implString);
                    return;
                }
                if (either instanceof Right && (tuple23 = (Tuple2)((Right)either).value()) != null) {
                    List diags = (List)tuple23._1();
                    TDMLDFDLProcessor proc = (TDMLDFDLProcessor)tuple23._2();
                    this.processor_$eq(proc);
                    this.runUnparserExpectErrors(optExpectedData, optErrors, optWarnings, optValidationErrors, implString, (Iterable<Diagnostic>)CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala());
                    return;
                }
                throw new MatchError(either);
            }
        }
        throw TDMLException$.MODULE$.apply("Either tdml:document or tdml:errors must be present in the test.", implString);
    }

    public void runUnparserExpectSuccess(InputStream expectedData, Option<Seq<ExpectedWarnings>> optWarnings, Option<Seq<ExpectedValidationErrors>> optValidationErrors, RoundTrip roundTrip, Option<String> implString, Iterable<Diagnostic> compileWarnings) {
        long fullBytesNeeded;
        TDMLUnparseResult tDMLUnparseResult;
        if (roundTrip == TwoPassRoundTrip$.MODULE$) {
            throw Assert$.MODULE$.usageError("roundTrip.ne(org.apache.daffodil.tdml.TwoPassRoundTrip)");
        }
        Elem infosetXML = this.inputInfoset().dfdlInfoset().contents();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            this.processor_$eq(this.processor().withExternalDFDLVariables(this.externalVarBindings()));
            tDMLUnparseResult = this.processor().unparse((Node)infosetXML, (OutputStream)outStream);
        }
        catch (Throwable t) {
            throw this.toss(t, implString);
        }
        TDMLUnparseResult actual = tDMLUnparseResult;
        if (actual.isProcessingError()) {
            throw TDMLException$.MODULE$.apply((Iterable<Throwable>)CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala(), implString);
        }
        byte[] testData = outStream.toByteArray();
        long testDataLength = actual.finalBitPos0b();
        if (testDataLength >= 0L && (long)testData.length != (fullBytesNeeded = (testDataLength + 7L) / 8L)) {
            throw TDMLException$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unparse result data was %d bytes, but the result length (%d bits) requires %d bytes."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)testData.length), BoxesRunTime.boxToLong((long)testDataLength), BoxesRunTime.boxToLong((long)fullBytesNeeded)})), implString);
        }
        if (actual.isScannable()) {
            VerifyTestCase$.MODULE$.verifyTextData(expectedData, outStream, actual.encodingName(), implString);
        } else {
            VerifyTestCase$.MODULE$.verifyBinaryOrMixedData(expectedData, outStream, implString);
        }
        Buffer allDiags = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala().$plus$plus(compileWarnings);
        this.checkDiagnosticMessages((Iterable<Diagnostic>)allDiags, (Option<Seq<ExpectedErrors>>)None$.MODULE$, optWarnings, optValidationErrors, implString);
        if (roundTrip == OnePassRoundTrip$.MODULE$) {
            None$ none$;
            TDMLParseResult tDMLParseResult;
            try {
                tDMLParseResult = this.processor().parse(new ByteArrayInputStream(outStream.toByteArray()), testDataLength);
            }
            catch (Throwable t) {
                throw this.toss(t, implString);
            }
            TDMLParseResult parseActual = tDMLParseResult;
            if (parseActual.isProcessingError()) {
                List<Diagnostic> diagObjs = parseActual.getDiagnostics();
                if (diagObjs.size() == 1) {
                    throw (Throwable)diagObjs.get(0);
                }
                String diags = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(parseActual.getDiagnostics()).asScala().map((Function1 & Serializable)_$16 -> _$16.toString())).mkString("\n");
                throw TDMLException$.MODULE$.apply(diags, implString);
            }
            DataLocation loc = parseActual.currentLocation();
            if (loc.bitPos1b() >= 0L && loc.bitPos1b() < testDataLength) {
                String leftOverMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Left over data. Consumed %s bit(s) with %s bit(s) remaining."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(loc.bitPos1b() - 1L)), BoxesRunTime.boxToLong((long)(testDataLength - (loc.bitPos1b() - 1L)))}));
                none$ = Some$.MODULE$.apply((Object)TDMLException$.MODULE$.apply(leftOverMsg, implString));
            } else {
                none$ = None$.MODULE$;
            }
            None$ leftOverException = none$;
            Node xmlNode = parseActual.getResult();
            VerifyTestCase$.MODULE$.verifyParserTestData(xmlNode, this.inputInfoset(), implString);
            leftOverException.map((Function1 & Serializable)_$17 -> {
                throw _$17;
            });
            parseActual.cleanUp();
        }
        actual.cleanUp();
    }

    public void runUnparserExpectErrors(Option<InputStream> optExpectedData, Option<Seq<ExpectedErrors>> optErrors, Option<Seq<ExpectedWarnings>> optWarnings, Option<Seq<ExpectedValidationErrors>> optValidationErrors, Option<String> implString, Iterable<Diagnostic> compileWarnings) {
        TDMLUnparseResult tDMLUnparseResult;
        try {
            this.processor_$eq(this.processor().withExternalDFDLVariables(this.externalVarBindings()));
        }
        catch (Exception e) {
            throw TDMLException$.MODULE$.apply(e, implString);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (this.optInputInfoset().isEmpty()) {
            throw TDMLException$.MODULE$.apply("No infoset specified, but one is required to run the test.", implString);
        }
        Elem infosetXML = this.inputInfoset().dfdlInfoset().contents();
        try {
            tDMLUnparseResult = this.processor().unparse((Node)infosetXML, (OutputStream)outStream);
        }
        catch (Throwable t) {
            throw this.toss(t, implString);
        }
        TDMLUnparseResult actual = tDMLUnparseResult;
        Option dataErrors = optExpectedData.flatMap((Function1 & Serializable)data -> {
            None$ none$;
            try {
                if (actual.isScannable()) {
                    VerifyTestCase$.MODULE$.verifyTextData((InputStream)data, outStream, actual.encodingName(), implString);
                } else {
                    VerifyTestCase$.MODULE$.verifyBinaryOrMixedData((InputStream)data, outStream, implString);
                }
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof TDMLException) {
                    Throwable x = (Throwable)((Object)((TDMLException)((Object)throwable2)));
                    none$ = Some$.MODULE$.apply((Object)new TDMLDiagnostic(x.getMessage(), implString));
                }
                throw throwable;
            }
            return none$;
        });
        actual.cleanUp();
        Iterable diagnostics = (Iterable)((IterableOps)compileWarnings.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(actual.getDiagnostics()).asScala())).$plus$plus((IterableOnce)dataErrors);
        if (diagnostics.isEmpty()) {
            throw TDMLException$.MODULE$.apply("Unparser test expected error. Didn't get one.", implString);
        }
        this.checkDiagnosticMessages((Iterable<Diagnostic>)diagnostics, optErrors, optWarnings, optValidationErrors, implString);
    }

    public UnparserTestCase copy(NodeSeq ptc, DFDLTestSuite parentArg) {
        return new UnparserTestCase(ptc, parentArg);
    }

    public NodeSeq copy$default$1() {
        return this.ptc();
    }

    public DFDLTestSuite copy$default$2() {
        return this.parentArg();
    }

    public NodeSeq _1() {
        return this.ptc();
    }

    public DFDLTestSuite _2() {
        return this.parentArg();
    }
}

