/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.Serializable;
import java.util.List;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.tdml.TDMLCompileResultCache$;
import org.apache.daffodil.tdml.TDMLCompileResultCacheKey;
import org.apache.daffodil.tdml.TDMLCompileResultCacheValue;
import org.apache.daffodil.tdml.TDMLCompileResultCacheValue$;
import org.apache.daffodil.tdml.processor.AbstractTDMLDFDLProcessorFactory;
import org.apache.daffodil.tdml.processor.TDMLDFDLProcessor;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.MapOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;

public class TDMLCompileResultCache
implements Product,
Serializable {
    private final Option entryExpireDurationSeconds;
    private final HashMap<TDMLCompileResultCacheKey, TDMLCompileResultCacheValue> cache;

    public static TDMLCompileResultCache apply(Option<Object> option) {
        return TDMLCompileResultCache$.MODULE$.apply(option);
    }

    public static TDMLCompileResultCache fromProduct(Product product) {
        return TDMLCompileResultCache$.MODULE$.fromProduct(product);
    }

    public static TDMLCompileResultCache unapply(TDMLCompileResultCache tDMLCompileResultCache) {
        return TDMLCompileResultCache$.MODULE$.unapply(tDMLCompileResultCache);
    }

    public TDMLCompileResultCache(Option<Object> entryExpireDurationSeconds) {
        this.entryExpireDurationSeconds = entryExpireDurationSeconds;
        this.cache = new HashMap();
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -191742801, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TDMLCompileResultCache)) return false;
        TDMLCompileResultCache tDMLCompileResultCache = (TDMLCompileResultCache)object;
        Option<Object> option = this.entryExpireDurationSeconds();
        Option<Object> option2 = tDMLCompileResultCache.entryExpireDurationSeconds();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!tDMLCompileResultCache.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TDMLCompileResultCache;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "TDMLCompileResultCache";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "entryExpireDurationSeconds";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<Object> entryExpireDurationSeconds() {
        return this.entryExpireDurationSeconds;
    }

    private void removeExpiredEntries() {
        long now = System.currentTimeMillis();
        Iterable keysToRemove = ((MapOps)this.cache.filterNot((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TDMLCompileResultCacheKey k = (TDMLCompileResultCacheKey)tuple2._1();
                TDMLCompileResultCacheValue v = (TDMLCompileResultCacheValue)tuple2._2();
                return v.optExpireTimeMillis().forall((Function1)(JFunction1.mcZJ.sp & Serializable)_$43 -> now < _$43);
            }
            throw new MatchError((Object)tuple2);
        })).keys();
        keysToRemove.foreach((Function1 & Serializable)key -> this.cache.remove(key));
    }

    public void setEntriesFinished(Set<TDMLCompileResultCacheKey> keys) {
        TDMLCompileResultCache tDMLCompileResultCache = this;
        synchronized (tDMLCompileResultCache) {
            long now = System.currentTimeMillis();
            Some expireTime = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(now + BoxesRunTime.unboxToLong((Object)this.entryExpireDurationSeconds().get()) * 1000L)));
            keys.foreach((Function1)(JProcedure1 & Serializable)key -> {
                Option optVal = this.cache.get(key);
                if (optVal.isDefined()) {
                    ((TDMLCompileResultCacheValue)optVal.get()).optExpireTimeMillis_$eq((Option<Object>)expireTime);
                    return;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> getCompileResult(AbstractTDMLDFDLProcessorFactory impl, TDMLCompileResultCacheKey key, String validation) {
        TDMLCompileResultCache tDMLCompileResultCache = this;
        synchronized (tDMLCompileResultCache) {
            TDMLCompileResultCacheValue tDMLCompileResultCacheValue;
            Option optVal;
            if (this.entryExpireDurationSeconds().isDefined()) {
                this.removeExpiredEntries();
            }
            if ((optVal = this.cache.get((Object)key)).isDefined()) {
                TDMLCompileResultCacheValue v = (TDMLCompileResultCacheValue)optVal.get();
                v.optExpireTimeMillis_$eq((Option<Object>)None$.MODULE$);
                tDMLCompileResultCacheValue = v;
            } else {
                Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> compileResult = impl.getProcessor(key.suppliedSchema(), key.optRootName(), key.optRootNamespace(), key.tunables());
                Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> either = compileResult;
                if (either instanceof Left) {
                    List diags = (List)((Left)either).value();
                    if (!CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala().exists((Function1 & Serializable)_$44 -> _$44.isError())) {
                        throw Assert$.MODULE$.abort("Invariant broken: scala.jdk.CollectionConverters.ListHasAsScala[org.apache.daffodil.api.Diagnostic](diags).asScala.exists(((_$44: org.apache.daffodil.api.Diagnostic) => _$44.isError()))");
                    }
                } else {
                    if (!(either instanceof Right)) throw new MatchError(either);
                    Tuple2 tuple2 = (Tuple2)((Right)either).value();
                    if (tuple2 == null) throw new MatchError(either);
                    List diags = (List)tuple2._1();
                    if (!CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala().forall((Function1 & Serializable)_$45 -> !_$45.isError())) {
                        throw Assert$.MODULE$.abort("Invariant broken: scala.jdk.CollectionConverters.ListHasAsScala[org.apache.daffodil.api.Diagnostic](diags).asScala.forall(((_$45: org.apache.daffodil.api.Diagnostic) => _$45.isError().unary_!))");
                    }
                }
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"off");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, compileResult);
                ListMap compileResultMap = (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                TDMLCompileResultCacheValue cacheValue = TDMLCompileResultCacheValue$.MODULE$.apply((ListMap<String, Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>>>)compileResultMap, (Option<Object>)None$.MODULE$);
                TDMLCompileResultCacheKey tDMLCompileResultCacheKey = (TDMLCompileResultCacheKey)Predef$.MODULE$.ArrowAssoc((Object)key);
                this.cache.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tDMLCompileResultCacheKey, (Object)cacheValue));
                tDMLCompileResultCacheValue = cacheValue;
            }
            TDMLCompileResultCacheValue compileResultCacheValue = tDMLCompileResultCacheValue;
            ListMap<String, Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>>> compileResultMap = compileResultCacheValue.compileResultMap();
            Either compileResult = (Either)compileResultMap.get((Object)validation).getOrElse(() -> TDMLCompileResultCache.$anonfun$60(compileResultMap, validation, compileResultCacheValue));
            return compileResult;
        }
    }

    public TDMLCompileResultCache copy(Option<Object> entryExpireDurationSeconds) {
        return new TDMLCompileResultCache(entryExpireDurationSeconds);
    }

    public Option<Object> copy$default$1() {
        return this.entryExpireDurationSeconds();
    }

    public Option<Object> _1() {
        return this.entryExpireDurationSeconds();
    }

    private static final Either $anonfun$60(ListMap compileResultMap$1, String validation$1, TDMLCompileResultCacheValue compileResultCacheValue$1) {
        Either newCr = ((Either)compileResultMap$1.apply((Object)"off")).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List diags = (List)tuple2._1();
                TDMLDFDLProcessor proc = (TDMLDFDLProcessor)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)diags, (Object)proc.withValidation(validation$1));
            }
            throw new MatchError((Object)tuple2);
        });
        ListMap newCrMap = compileResultMap$1.updated((Object)validation$1, (Object)newCr);
        compileResultCacheValue$1.compileResultMap_$eq((ListMap<String, Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>>>)newCrMap);
        return newCr;
    }
}

