/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.activemq.artemis.commons.shaded.json.JsonNumber;
import org.apache.activemq.artemis.commons.shaded.json.JsonValue;

final class JsonDoubleImpl
implements JsonNumber,
Serializable {
    private final double value;
    private Integer hashCode = null;

    JsonDoubleImpl(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("double value must not be NaN or Infinite");
        }
        this.value = value;
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public boolean isIntegral() {
        return false;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public int intValueExact() {
        this.checkFractionalPart();
        return this.intValue();
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public long longValueExact() {
        this.checkFractionalPart();
        return (long)this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigDecimal(this.toString()).toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return new BigDecimal(this.toString()).toBigIntegerExact();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.toString());
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.bigDecimalValue().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (JsonDoubleImpl.class.isInstance(obj)) {
            return ((JsonDoubleImpl)JsonDoubleImpl.class.cast((Object)obj)).value == this.value;
        }
        return JsonNumber.class.isInstance(obj) && Objects.equals(((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue(), this.bigDecimalValue());
    }

    private void checkFractionalPart() {
        if (this.value % 1.0 != 0.0) {
            throw new ArithmeticException("Not an int/long, use other value readers");
        }
    }
}

