/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.slf4j.Logger;

public class ActiveMQXARecoveryLogger_impl
implements ActiveMQXARecoveryLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQXARecoveryLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void noQueueOnTopic(String queueName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172007: Queue {} does not exist on the topic {}. It was deleted manually probably.", (Object)queueName, (Object)name);
        }
    }

    @Override
    public void recoveryConnectFailed(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172008: XA Recovery can not connect to any broker on recovery {}", (Object)s);
        }
    }

    @Override
    public void xaRecoverError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172013: Error in XA Recovery recover", (Throwable)e);
        }
    }

    @Override
    public void xaRecoverConnectionError(ClientSessionFactory csf, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172014: Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass", (Object)csf, (Object)e);
        }
    }

    @Override
    public void xaRecoverAutoConnectionError(XARecoveryConfig csf, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ172015: Can not connect to {} on auto-generated resource recovery", (Object)csf, (Object)e);
        }
    }

    @Override
    public void xaRecoveryError(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ172016: Error in XA Recovery", (Throwable)e);
        }
    }
}

