/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cxf.rs.security.httpsignature.SignatureCreator;
import org.apache.cxf.rs.security.httpsignature.TomitribeSignatureCreator;
import org.apache.cxf.rs.security.httpsignature.provider.KeyProvider;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

public class MessageSigner {
    private final SignatureCreator signatureCreator;

    public MessageSigner(String signatureAlgorithmName, KeyProvider keyProvider, String keyId) {
        this(signatureAlgorithmName, keyProvider, keyId, Collections.emptyList());
    }

    public MessageSigner(String signatureAlgorithmName, KeyProvider keyProvider, String keyId, List<String> headersToSign) {
        this.signatureCreator = new TomitribeSignatureCreator(Objects.requireNonNull(signatureAlgorithmName), Objects.requireNonNull(keyProvider), Objects.requireNonNull(keyId), headersToSign);
    }

    public MessageSigner(KeyProvider keyProvider, String keyId) {
        this(keyProvider, keyId, Collections.emptyList());
    }

    public MessageSigner(KeyProvider keyProvider, String keyId, List<String> headersToSign) {
        this("rsa-sha256", keyProvider, keyId, headersToSign);
    }

    public void sign(Map<String, List<String>> messageHeaders, String uri, String method) throws IOException {
        SignatureHeaderUtils.inspectMessageHeaders(messageHeaders);
        Objects.requireNonNull(uri);
        Objects.requireNonNull(method);
        messageHeaders.put("Signature", Collections.singletonList(this.signatureCreator.createSignature(messageHeaders, uri, method)));
    }
}

