/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public final class JCacheUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(JCacheUtil.class);
    private static final boolean JCACHE_INSTALLED;

    private JCacheUtil() {
    }

    public static boolean isJCacheInstalled() {
        return JCACHE_INSTALLED;
    }

    static {
        boolean jcacheInstalled = false;
        try {
            Class<?> caching = Class.forName("javax.cache.Caching");
            Class<?> cachingProvider = Class.forName("javax.cache.spi.CachingProvider");
            if (caching != null) {
                jcacheInstalled = MethodHandles.publicLookup().findStatic(caching, "getCachingProvider", MethodType.methodType(cachingProvider)).invoke() != null;
            }
        }
        catch (Throwable e) {
            LOG.fine("No JCache SPIs detected on classpath: " + e.getMessage());
        }
        JCACHE_INSTALLED = jcacheInstalled;
    }
}

