/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.plugin.impl.LoggingActiveMQServerPluginLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.slf4j.Logger;

public class LoggingActiveMQServerPluginLogger_impl
implements LoggingActiveMQServerPluginLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public LoggingActiveMQServerPluginLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void afterCreateConnection(RemotingConnection connection) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841000: created connection: {}", (Object)connection);
        }
    }

    @Override
    public void afterDestroyConnection(RemotingConnection connection) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841001: destroyed connection: {}", (Object)connection);
        }
    }

    @Override
    public void afterCreateSession(String sessionName, Object sesssionConnectionID, String remoteAddress) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841002: created session name: {}, session connectionID: {}, remote address {}", new Object[]{sessionName, sesssionConnectionID, remoteAddress});
        }
    }

    @Override
    public void afterCloseSession(String sessionName, boolean sesssionConnectionID, String remoteAddress) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841003: closed session with session name: {}, failed: {}, RemoteAddress: {}", new Object[]{sessionName, sesssionConnectionID, remoteAddress});
        }
    }

    @Override
    public void afterSessionMetadataAdded(String sessionName, String key, String data) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841004: added session metadata for session name : {}, key: {}, data: {}", new Object[]{sessionName, key, data});
        }
    }

    @Override
    public void afterCreateConsumer(String consumerID, String sessionID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841005: created consumer with ID: {}, with session name: {}", (Object)consumerID, (Object)sessionID);
        }
    }

    @Override
    public void afterCloseConsumer(String consumerID, String sessionID, boolean failed) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841006: closed consumer ID: {}, with  consumer Session: {}, failed: {}", new Object[]{consumerID, sessionID, failed});
        }
    }

    @Override
    public void afterCreateQueue(Queue queue) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841007: created queue: {}", (Object)queue);
        }
    }

    @Override
    public void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841008: destroyed queue: {}, with args address: {}, session: {}, checkConsumerCount: {}, removeConsumers: {}, autoDeleteAddress: {}", new Object[]{queue, address, session, checkConsumerCount, removeConsumers, autoDeleteAddress});
        }
    }

    @Override
    public void afterSend(String messageID, RoutingStatus result, String tx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841009: sent message with ID: {}, result: {}, transaction: {}", new Object[]{messageID, result, tx});
        }
    }

    @Override
    public void afterMessageRoute(String messageID, RoutingStatus result) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841010: routed message with ID: {}, result: {}", (Object)messageID, (Object)result);
        }
    }

    @Override
    public void afterDeliverNoConsumer(String messageID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841011: delivered message with message ID: {}, consumer info UNAVAILABLE", (Object)messageID);
        }
    }

    @Override
    public void afterDeliver(String messageID, SimpleString queueAddress, SimpleString queueName, String consumerSessionID, long consumerID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841012: delivered message with message ID: {}, to consumer on address: {}, queue: {}, consumer sessionID: {}, consumerID: {}", new Object[]{messageID, queueAddress, queueName, consumerSessionID, consumerID});
        }
    }

    @Override
    public void messageExpired(MessageReference message, SimpleString messageExpiryAddress) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841013: expired message: {}, messageExpiryAddress: {}", (Object)message, (Object)messageExpiryAddress);
        }
    }

    @Override
    public void messageAcknowledged(MessageReference ref, Transaction tx) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841014: acknowledged message: {}, with transaction: {}", (Object)ref, (Object)tx);
        }
    }

    @Override
    public void afterDeployBridge(Bridge config) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841015: deployed bridge: {}", (Object)config);
        }
    }

    @Override
    public void criticalFailure(CriticalComponent components) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841016: criticalFailure called with criticalComponent: {}", (Object)components);
        }
    }

    @Override
    public void onSendError(String messageID, String sessionName, String sessionConnectionID, Exception e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841017: error sending message with ID: {}, session name: {}, session connectionID: {}, exception: {}", new Object[]{messageID, sessionName, sessionConnectionID, e});
        }
    }

    @Override
    public void onMessageRouteError(String messageID, Exception e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ841018: error routing message with ID: {}, exception: {}", (Object)messageID, (Object)e);
        }
    }

    @Override
    public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String publicAddress) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843000: beforeCreateSession called with name: {}, username: {}, minLargeMessageSize: {}, connection: {}, autoCommitSends: {}, autoCommitAcks: {}, preAcknowledge: {}, xa: {}, publicAddress: {}", new Object[]{name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, publicAddress});
        }
    }

    @Override
    public void beforeCloseSession(String sessionName, ServerSession session, boolean failed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843001: beforeCloseSession called with session name : {}, session: {}, failed: {}", new Object[]{sessionName, session, failed});
        }
    }

    @Override
    public void beforeSessionMetadataAdded(String sessionName, ServerSession session, String key, String data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843002: beforeSessionMetadataAdded called with session name: {} , session: {}, key: {}, data: {}", new Object[]{sessionName, session, key, data});
        }
    }

    @Override
    public void afterSessionMetadataAddedDetails(String sessionName, ServerSession session, String key, String data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843003: added session metadata for session name : {}, session: {}, key: {}, data: {}", new Object[]{sessionName, session, key, data});
        }
    }

    @Override
    public void beforeCreateConsumer(String consumerID, QueueBinding queueBinding, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843004: beforeCreateConsumer called with ConsumerID: {}, QueueBinding: {}, filterString: {}, browseOnly: {}, supportLargeMessage: {}", new Object[]{consumerID, queueBinding, filterString, browseOnly, supportLargeMessage});
        }
    }

    @Override
    public void beforeCloseConsumer(ServerConsumer consumer, String sessionID, boolean failed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843005: beforeCloseConsumer called with consumer: {}, consumer sessionID: {}, failed: {}", new Object[]{consumer, sessionID, failed});
        }
    }

    @Override
    public void beforeCreateQueue(QueueConfiguration queueConfig) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843006: beforeCreateQueue called with queueConfig: {}", (Object)queueConfig);
        }
    }

    @Override
    public void beforeDestroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843007: beforeDestroyQueue called with queueName: {}, session: {}, checkConsumerCount: {}, removeConsumers: {}, autoDeleteAddress: {}", new Object[]{queueName, session, checkConsumerCount, removeConsumers, autoDeleteAddress});
        }
    }

    @Override
    public void beforeSend(Message message, Transaction tx, ServerSession session, boolean direct, boolean noAutoCreateQueue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843008: beforeSend called with message: {}, tx: {}, session: {}, direct: {}, noAutoCreateQueue: {}", new Object[]{message, tx, session, direct, noAutoCreateQueue});
        }
    }

    @Override
    public void afterSendDetails(Message message, String result, Transaction tx, String sessionName, String connectionID, boolean direct, boolean noAutoCreateQueue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843009: afterSend message: {}, result: {}, transaction: {}, session: {}, connection: {}, direct: {}, noAutoCreateQueue: {}", new Object[]{message, result, tx, sessionName, connectionID, direct, noAutoCreateQueue});
        }
    }

    @Override
    public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843010: beforeMessageRoute called with message: {}, context: {}, direct: {}, rejectDuplicates: {}", new Object[]{message, context, direct, rejectDuplicates});
        }
    }

    @Override
    public void afterMessageRouteDetails(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843011: afterMessageRoute message: {}, with context: {}, direct: {}, rejectDuplicates: {}", new Object[]{message, context, direct, rejectDuplicates});
        }
    }

    @Override
    public void beforeDeliver(ServerConsumer consumer, MessageReference reference) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843012: beforeDeliver called with consumer: {}, reference: {}", (Object)consumer, (Object)reference);
        }
    }

    @Override
    public void afterDeliverDetails(String messageID, SimpleString queueAddress, SimpleString queueName, String consumerSessionID, long consumerID, MessageReference reference, ServerConsumer consumer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843013: delivered message with message ID: {} to consumer on address: {}, queue: {}, consumer sessionID: {}, consumerID: {}, full message reference: {}, full consumer: {}", new Object[]{messageID, queueAddress, queueName, consumerSessionID, consumerID, reference, consumer});
        }
    }

    @Override
    public void messageAcknowledgedDetails(String messageID, String sessionID, String consumerID, String queueName, String tx, AckReason reason) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843014: messageAcknowledged ID: {}, sessionID: {}, consumerID: {}, queue: {}, transaction: {}, ackReason: {}", new Object[]{messageID, sessionID, consumerID, queueName, tx, reason});
        }
    }

    @Override
    public void beforeDeployBridge(BridgeConfiguration config) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843015: beforeDeployBridge called with bridgeConfiguration: {}", (Object)config);
        }
    }

    @Override
    public void onSendErrorDetails(String messageID, Message message, String sessionName, Transaction tx, ServerSession session, boolean direct, boolean noAutoCreateQueue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843016: onSendError message ID: {}, message {}, session name: {} with tx: {}, session: {}, direct: {}, noAutoCreateQueue: {}", new Object[]{messageID, message, sessionName, tx, session, direct, noAutoCreateQueue});
        }
    }

    @Override
    public void onMessageRouteErrorDetails(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843017: onMessageRouteError message: {}, with context: {}, direct: {}, rejectDuplicates: {}", new Object[]{message, context, direct, rejectDuplicates});
        }
    }

    @Override
    public void rolledBackTransaction(Transaction tx, String resource) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ843018: rolled back transaction {} involving {}", (Object)tx, (Object)resource);
        }
    }
}

