/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum AddressField {
    ID("id"),
    NAME("name"),
    ROUTING_TYPES("routingTypes"),
    QUEUE_COUNT("queueCount"),
    INTERNAL("internal"),
    TEMPORARY("temporary"),
    AUTO_CREATED("autoCreated"),
    PAUSED("paused"),
    CURRENT_DUPLICATE_ID_CACHE_SIZE("currentDuplicateIdCacheSize"),
    RETROACTIVE_RESOURCE("retroactiveResource"),
    UNROUTED_MESSAGE_COUNT("unroutedMessageCount"),
    ROUTED_MESSAGE_COUNT("routedMessageCount"),
    MESSAGE_COUNT("MessageCount"),
    NUMBER_OF_BYTES_PER_PAGE("numberOfBytesPerPage"),
    ADDRESS_LIMIT_PERCENT("addressLimitPercent"),
    PAGING("paging"),
    NUMBER_OF_PAGES("numberOfPages"),
    ADDRESS_SIZE("addressSize"),
    MAX_PAGE_READ_BYTES("maxPageReadBytes"),
    MAX_PAGE_READ_MESSAGES("maxPageReadMessages"),
    PREFETCH_PAGE_BYTES("prefetchPageBytes"),
    PREFETCH_PAGE_MESSAGES("prefetchPageMessages");

    private static final Map<String, AddressField> lookup;
    private final String name;

    public String getName() {
        return this.name;
    }

    private AddressField(String name) {
        this.name = name;
    }

    public static AddressField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, AddressField>(String.CASE_INSENSITIVE_ORDER);
        for (AddressField e : AddressField.values()) {
            lookup.put(e.name, e);
        }
    }
}

