/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.management.impl.ManagementRemotingConnection;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.DummyOperationContext;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.RunnableEx;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public abstract class AbstractControl
extends StandardMBean {
    protected final StorageManager storageManager;

    public AbstractControl(Class<?> clazz, StorageManager storageManager) throws NotCompliantMBeanException {
        super(clazz);
        this.storageManager = storageManager;
    }

    protected void clearIO() {
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
    }

    protected void blockOnIO() {
        if (this.storageManager != null && this.storageManager.isStarted()) {
            try {
                this.storageManager.waitOnOperations();
                this.storageManager.clearContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected abstract MBeanOperationInfo[] fillMBeanOperationInfo();

    protected abstract MBeanAttributeInfo[] fillMBeanAttributeInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object tcclCall(ClassLoader loader, Callable<Object> callable) throws Exception {
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object object = callable.call();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tcclInvoke(ClassLoader loader, RunnableEx runnableEx) throws Exception {
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            runnableEx.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTCCL);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMBeanInfo((Object)this);
        }
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), this.fillMBeanAttributeInfo(), info.getConstructors(), this.fillMBeanOperationInfo(), info.getNotifications());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendMessage(SimpleString address, ActiveMQServer server, Map<String, String> headers, int type, String body, boolean durable, String user, String password, boolean createMessageId) throws Exception {
        ManagementRemotingConnection fakeConnection = new ManagementRemotingConnection();
        String validatedUser = server.validateUser(user, password, fakeConnection, null);
        ServerSession serverSession = server.createSession("management::" + UUIDGenerator.getInstance().generateStringUUID(), user, password, Integer.MAX_VALUE, fakeConnection, true, true, false, false, address.toString(), fakeConnection.callback, false, new DummyOperationContext(), Collections.emptyMap(), null, validatedUser, false);
        try {
            CoreMessage message = new CoreMessage(this.storageManager.generateID(), 50);
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    message.putStringProperty(header.getKey(), header.getValue());
                }
            }
            message.setType((byte)type);
            message.setDurable(durable);
            message.setTimestamp(System.currentTimeMillis());
            if (body != null) {
                if (type == 3) {
                    message.getBodyBuffer().writeNullableSimpleString(SimpleString.of((String)body));
                } else {
                    message.getBodyBuffer().writeBytes(Base64.decode((String)body));
                }
            }
            message.setAddress(address);
            if (createMessageId) {
                UUID userID = UUIDGenerator.getInstance().generateUUID();
                message.setUserID(userID);
            }
            serverSession.send((Message)message, false, null);
            String string = "" + message.getMessageID();
            return string;
        }
        finally {
            try {
                serverSession.close(false);
            }
            catch (Exception exception) {}
        }
    }
}

