/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Interact with IBM watsonx.ai foundation models for text generation, chat,
 * embeddings, and more.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WatsonxAiEndpointBuilderFactory {

    /**
     * Builder for endpoint for the IBM watsonx.ai component.
     */
    public interface WatsonxAiEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWatsonxAiEndpointBuilder advanced() {
            return (AdvancedWatsonxAiEndpointBuilder) this;
        }

        /**
         * The watsonx.ai base URL (e.g., https://us-south.ml.cloud.ibm.com).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param baseUrl the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder baseUrl(String baseUrl) {
            doSetProperty("baseUrl", baseUrl);
            return this;
        }
        /**
         * IBM Cloud project ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param projectId the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder projectId(String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
        /**
         * IBM Cloud deployment space ID (alternative to projectId).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param spaceId the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder spaceId(String spaceId) {
            doSetProperty("spaceId", spaceId);
            return this;
        }
        /**
         * The watsonx.ai WX platform URL for tool operations (e.g.,
         * https://api.dataplatform.cloud.ibm.com/wx).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param wxUrl the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder wxUrl(String wxUrl) {
            doSetProperty("wxUrl", wxUrl);
            return this;
        }
        /**
         * Cloud Object Storage URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param cosUrl the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder cosUrl(String cosUrl) {
            doSetProperty("cosUrl", cosUrl);
            return this;
        }
        /**
         * Deployed model ID (for deployment operations).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param deploymentId the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Whether to detect HAP (Harmful, Abusive, Profane content).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detectHap the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder detectHap(Boolean detectHap) {
            doSetProperty("detectHap", detectHap);
            return this;
        }
        /**
         * Whether to detect HAP (Harmful, Abusive, Profane content).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detectHap the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder detectHap(String detectHap) {
            doSetProperty("detectHap", detectHap);
            return this;
        }
        /**
         * Detection threshold (0.0 to 1.0).
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param detectionThreshold the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder detectionThreshold(Double detectionThreshold) {
            doSetProperty("detectionThreshold", detectionThreshold);
            return this;
        }
        /**
         * Detection threshold (0.0 to 1.0).
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param detectionThreshold the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder detectionThreshold(String detectionThreshold) {
            doSetProperty("detectionThreshold", detectionThreshold);
            return this;
        }
        /**
         * Whether to detect PII (Personal Identifiable Information).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detectPii the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder detectPii(Boolean detectPii) {
            doSetProperty("detectPii", detectPii);
            return this;
        }
        /**
         * Whether to detect PII (Personal Identifiable Information).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param detectPii the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder detectPii(String detectPii) {
            doSetProperty("detectPii", detectPii);
            return this;
        }
        /**
         * COS bucket for document storage.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param documentBucket the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder documentBucket(String documentBucket) {
            doSetProperty("documentBucket", documentBucket);
            return this;
        }
        /**
         * COS connection ID for document storage.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param documentConnectionId the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder documentConnectionId(String documentConnectionId) {
            doSetProperty("documentConnectionId", documentConnectionId);
            return this;
        }
        /**
         * Frequency penalty for chat.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param frequencyPenalty the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder frequencyPenalty(Double frequencyPenalty) {
            doSetProperty("frequencyPenalty", frequencyPenalty);
            return this;
        }
        /**
         * Frequency penalty for chat.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param frequencyPenalty the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder frequencyPenalty(String frequencyPenalty) {
            doSetProperty("frequencyPenalty", frequencyPenalty);
            return this;
        }
        /**
         * Maximum completion tokens for chat.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param maxCompletionTokens the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            doSetProperty("maxCompletionTokens", maxCompletionTokens);
            return this;
        }
        /**
         * Maximum completion tokens for chat.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param maxCompletionTokens the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder maxCompletionTokens(String maxCompletionTokens) {
            doSetProperty("maxCompletionTokens", maxCompletionTokens);
            return this;
        }
        /**
         * Maximum new tokens to generate.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param maxNewTokens the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder maxNewTokens(Integer maxNewTokens) {
            doSetProperty("maxNewTokens", maxNewTokens);
            return this;
        }
        /**
         * Maximum new tokens to generate.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param maxNewTokens the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder maxNewTokens(String maxNewTokens) {
            doSetProperty("maxNewTokens", maxNewTokens);
            return this;
        }
        /**
         * Foundation model ID (e.g., ibm/granite-13b-instruct-v2).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param modelId the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder modelId(String modelId) {
            doSetProperty("modelId", modelId);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.watsonx.ai.WatsonxAiOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder operation(org.apache.camel.component.ibm.watsonx.ai.WatsonxAiOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.watsonx.ai.WatsonxAiOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Presence penalty for chat.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param presencePenalty the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder presencePenalty(Double presencePenalty) {
            doSetProperty("presencePenalty", presencePenalty);
            return this;
        }
        /**
         * Presence penalty for chat.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param presencePenalty the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder presencePenalty(String presencePenalty) {
            doSetProperty("presencePenalty", presencePenalty);
            return this;
        }
        /**
         * Repetition penalty.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param repetitionPenalty the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder repetitionPenalty(Double repetitionPenalty) {
            doSetProperty("repetitionPenalty", repetitionPenalty);
            return this;
        }
        /**
         * Repetition penalty.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param repetitionPenalty the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder repetitionPenalty(String repetitionPenalty) {
            doSetProperty("repetitionPenalty", repetitionPenalty);
            return this;
        }
        /**
         * Number of top results to return for reranking.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param rerankTopN the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder rerankTopN(Integer rerankTopN) {
            doSetProperty("rerankTopN", rerankTopN);
            return this;
        }
        /**
         * Number of top results to return for reranking.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param rerankTopN the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder rerankTopN(String rerankTopN) {
            doSetProperty("rerankTopN", rerankTopN);
            return this;
        }
        /**
         * COS bucket for result storage.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param resultBucket the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder resultBucket(String resultBucket) {
            doSetProperty("resultBucket", resultBucket);
            return this;
        }
        /**
         * COS connection ID for result storage.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param resultConnectionId the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder resultConnectionId(String resultConnectionId) {
            doSetProperty("resultConnectionId", resultConnectionId);
            return this;
        }
        /**
         * Whether to return documents in rerank response.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param returnDocuments the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder returnDocuments(Boolean returnDocuments) {
            doSetProperty("returnDocuments", returnDocuments);
            return this;
        }
        /**
         * Whether to return documents in rerank response.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param returnDocuments the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder returnDocuments(String returnDocuments) {
            doSetProperty("returnDocuments", returnDocuments);
            return this;
        }
        /**
         * Temperature for randomness (0.0 to 2.0).
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder temperature(Double temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Temperature for randomness (0.0 to 2.0).
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder temperature(String temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Top K (top-k sampling).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder topK(Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Top K (top-k sampling).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Top P (nucleus sampling).
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder topP(Double topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Top P (nucleus sampling).
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder topP(String topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Maximum number of tokens accepted per input for embeddings. Truncates
         * from the end if exceeded.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param truncateInputTokens the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder truncateInputTokens(Integer truncateInputTokens) {
            doSetProperty("truncateInputTokens", truncateInputTokens);
            return this;
        }
        /**
         * Maximum number of tokens accepted per input for embeddings. Truncates
         * from the end if exceeded.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param truncateInputTokens the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder truncateInputTokens(String truncateInputTokens) {
            doSetProperty("truncateInputTokens", truncateInputTokens);
            return this;
        }
        /**
         * IBM Cloud API key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM watsonx.ai component.
     */
    public interface AdvancedWatsonxAiEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WatsonxAiEndpointBuilder basic() {
            return (WatsonxAiEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether to log HTTP requests to the watsonx.ai API.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param logRequests the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder logRequests(Boolean logRequests) {
            doSetProperty("logRequests", logRequests);
            return this;
        }
        /**
         * Whether to log HTTP requests to the watsonx.ai API.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param logRequests the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder logRequests(String logRequests) {
            doSetProperty("logRequests", logRequests);
            return this;
        }
        /**
         * Whether to log HTTP responses from the watsonx.ai API.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param logResponses the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder logResponses(Boolean logResponses) {
            doSetProperty("logResponses", logResponses);
            return this;
        }
        /**
         * Whether to log HTTP responses from the watsonx.ai API.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param logResponses the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder logResponses(String logResponses) {
            doSetProperty("logResponses", logResponses);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: advanced
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder timeout(Long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: advanced
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Whether to verify SSL certificates.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param verifySsl the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder verifySsl(Boolean verifySsl) {
            doSetProperty("verifySsl", verifySsl);
            return this;
        }
        /**
         * Whether to verify SSL certificates.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param verifySsl the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonxAiEndpointBuilder verifySsl(String verifySsl) {
            doSetProperty("verifySsl", verifySsl);
            return this;
        }
    }

    public interface WatsonxAiBuilders {
        /**
         * IBM watsonx.ai (camel-ibm-watsonx-ai)
         * Interact with IBM watsonx.ai foundation models for text generation,
         * chat, embeddings, and more.
         * 
         * Category: ai,cloud
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-ibm-watsonx-ai
         * 
         * @return the dsl builder for the headers' name.
         */
        default WatsonxAiHeaderNameBuilder ibmWatsonxAi() {
            return WatsonxAiHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM watsonx.ai (camel-ibm-watsonx-ai)
         * Interact with IBM watsonx.ai foundation models for text generation,
         * chat, embeddings, and more.
         * 
         * Category: ai,cloud
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-ibm-watsonx-ai
         * 
         * Syntax: <code>ibm-watsonx-ai:label</code>
         * 
         * Path parameter: label (required)
         * Logical name for the endpoint
         * 
         * @param path label
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder ibmWatsonxAi(String path) {
            return WatsonxAiEndpointBuilderFactory.endpointBuilder("ibm-watsonx-ai", path);
        }
        /**
         * IBM watsonx.ai (camel-ibm-watsonx-ai)
         * Interact with IBM watsonx.ai foundation models for text generation,
         * chat, embeddings, and more.
         * 
         * Category: ai,cloud
         * Since: 4.18
         * Maven coordinates: org.apache.camel:camel-ibm-watsonx-ai
         * 
         * Syntax: <code>ibm-watsonx-ai:label</code>
         * 
         * Path parameter: label (required)
         * Logical name for the endpoint
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default WatsonxAiEndpointBuilder ibmWatsonxAi(String componentName, String path) {
            return WatsonxAiEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM watsonx.ai component.
     */
    public static class WatsonxAiHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WatsonxAiHeaderNameBuilder INSTANCE = new WatsonxAiHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code WatsonxAiOperations} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiOperation}.
         */
        public String iBMWatsonxAiOperation() {
            return "CamelIBMWatsonxAiOperation";
        }
        /**
         * The input text/prompt for generation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiInput}.
         */
        public String iBMWatsonxAiInput() {
            return "CamelIBMWatsonxAiInput";
        }
        /**
         * The list of inputs for batch operations.
         * 
         * The option is a: {@code java.util.List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiInputs}.
         */
        public String iBMWatsonxAiInputs() {
            return "CamelIBMWatsonxAiInputs";
        }
        /**
         * The generated text output.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiGeneratedText}.
         */
        public String iBMWatsonxAiGeneratedText() {
            return "CamelIBMWatsonxAiGeneratedText";
        }
        /**
         * The model ID to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiModelId}.
         */
        public String iBMWatsonxAiModelId() {
            return "CamelIBMWatsonxAiModelId";
        }
        /**
         * The deployment ID to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDeploymentId}.
         */
        public String iBMWatsonxAiDeploymentId() {
            return "CamelIBMWatsonxAiDeploymentId";
        }
        /**
         * The space ID for deployment operations.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiSpaceId}.
         */
        public String iBMWatsonxAiSpaceId() {
            return "CamelIBMWatsonxAiSpaceId";
        }
        /**
         * The deployment name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDeploymentName}.
         */
        public String iBMWatsonxAiDeploymentName() {
            return "CamelIBMWatsonxAiDeploymentName";
        }
        /**
         * The deployed asset type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiDeploymentAssetType}.
         */
        public String iBMWatsonxAiDeploymentAssetType() {
            return "CamelIBMWatsonxAiDeploymentAssetType";
        }
        /**
         * The deployment status state.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDeploymentStatus}.
         */
        public String iBMWatsonxAiDeploymentStatus() {
            return "CamelIBMWatsonxAiDeploymentStatus";
        }
        /**
         * Temperature for randomness (0.0 to 2.0).
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiTemperature}.
         */
        public String iBMWatsonxAiTemperature() {
            return "CamelIBMWatsonxAiTemperature";
        }
        /**
         * Maximum new tokens to generate.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiMaxNewTokens}.
         */
        public String iBMWatsonxAiMaxNewTokens() {
            return "CamelIBMWatsonxAiMaxNewTokens";
        }
        /**
         * Top P (nucleus sampling).
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiTopP}.
         */
        public String iBMWatsonxAiTopP() {
            return "CamelIBMWatsonxAiTopP";
        }
        /**
         * Top K (top-k sampling).
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiTopK}.
         */
        public String iBMWatsonxAiTopK() {
            return "CamelIBMWatsonxAiTopK";
        }
        /**
         * Repetition penalty.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiRepetitionPenalty}.
         */
        public String iBMWatsonxAiRepetitionPenalty() {
            return "CamelIBMWatsonxAiRepetitionPenalty";
        }
        /**
         * The chat messages.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiMessages}.
         */
        public String iBMWatsonxAiMessages() {
            return "CamelIBMWatsonxAiMessages";
        }
        /**
         * The system message for chat (used to build messages if MESSAGES
         * header is not set).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiSystemMessage}.
         */
        public String iBMWatsonxAiSystemMessage() {
            return "CamelIBMWatsonxAiSystemMessage";
        }
        /**
         * The user message for chat (used to build messages if MESSAGES header
         * is not set, alternative to body).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiUserMessage}.
         */
        public String iBMWatsonxAiUserMessage() {
            return "CamelIBMWatsonxAiUserMessage";
        }
        /**
         * The tools available for function calling.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiTools}.
         */
        public String iBMWatsonxAiTools() {
            return "CamelIBMWatsonxAiTools";
        }
        /**
         * Tool choice option (auto, required, none).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiToolChoice}.
         */
        public String iBMWatsonxAiToolChoice() {
            return "CamelIBMWatsonxAiToolChoice";
        }
        /**
         * The embedding vectors result.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiEmbeddings}.
         */
        public String iBMWatsonxAiEmbeddings() {
            return "CamelIBMWatsonxAiEmbeddings";
        }
        /**
         * The query for reranking.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiRerankQuery}.
         */
        public String iBMWatsonxAiRerankQuery() {
            return "CamelIBMWatsonxAiRerankQuery";
        }
        /**
         * Number of top results to return for reranking.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiRerankTopN}.
         */
        public String iBMWatsonxAiRerankTopN() {
            return "CamelIBMWatsonxAiRerankTopN";
        }
        /**
         * The token count.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiTokenCount}.
         */
        public String iBMWatsonxAiTokenCount() {
            return "CamelIBMWatsonxAiTokenCount";
        }
        /**
         * The token IDs.
         * 
         * The option is a: {@code java.util.List<Integer>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiTokens}.
         */
        public String iBMWatsonxAiTokens() {
            return "CamelIBMWatsonxAiTokens";
        }
        /**
         * The file to upload.
         * 
         * The option is a: {@code java.io.File} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiFile}.
         */
        public String iBMWatsonxAiFile() {
            return "CamelIBMWatsonxAiFile";
        }
        /**
         * The file name when using InputStream input.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiFileName}.
         */
        public String iBMWatsonxAiFileName() {
            return "CamelIBMWatsonxAiFileName";
        }
        /**
         * The file path for extraction or classification (for files already in
         * COS).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiFilePath}.
         */
        public String iBMWatsonxAiFilePath() {
            return "CamelIBMWatsonxAiFilePath";
        }
        /**
         * The extraction request ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiExtractionId}.
         */
        public String iBMWatsonxAiExtractionId() {
            return "CamelIBMWatsonxAiExtractionId";
        }
        /**
         * The extraction status.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiExtractionStatus}.
         */
        public String iBMWatsonxAiExtractionStatus() {
            return "CamelIBMWatsonxAiExtractionStatus";
        }
        /**
         * The extracted text content.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiExtractedText}.
         */
        public String iBMWatsonxAiExtractedText() {
            return "CamelIBMWatsonxAiExtractedText";
        }
        /**
         * The COS bucket name for file operations.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiBucketName}.
         */
        public String iBMWatsonxAiBucketName() {
            return "CamelIBMWatsonxAiBucketName";
        }
        /**
         * Whether the upload operation was successful.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiUploadSuccess}.
         */
        public String iBMWatsonxAiUploadSuccess() {
            return "CamelIBMWatsonxAiUploadSuccess";
        }
        /**
         * Whether the delete operation was successful.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDeleteSuccess}.
         */
        public String iBMWatsonxAiDeleteSuccess() {
            return "CamelIBMWatsonxAiDeleteSuccess";
        }
        /**
         * The classification request ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiClassificationId}.
         */
        public String iBMWatsonxAiClassificationId() {
            return "CamelIBMWatsonxAiClassificationId";
        }
        /**
         * The classification status.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiClassificationStatus}.
         */
        public String iBMWatsonxAiClassificationStatus() {
            return "CamelIBMWatsonxAiClassificationStatus";
        }
        /**
         * The classification result (document type).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiClassificationResult}.
         */
        public String iBMWatsonxAiClassificationResult() {
            return "CamelIBMWatsonxAiClassificationResult";
        }
        /**
         * Whether the document was classified.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiDocumentClassified}.
         */
        public String iBMWatsonxAiDocumentClassified() {
            return "CamelIBMWatsonxAiDocumentClassified";
        }
        /**
         * Error message when classification or extraction fails.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiErrorMessage}.
         */
        public String iBMWatsonxAiErrorMessage() {
            return "CamelIBMWatsonxAiErrorMessage";
        }
        /**
         * Error code when classification or extraction fails.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiErrorCode}.
         */
        public String iBMWatsonxAiErrorCode() {
            return "CamelIBMWatsonxAiErrorCode";
        }
        /**
         * List of detectors to use.
         * 
         * The option is a: {@code
         * java.util.List<com.ibm.watsonx.ai.detection.detector.BaseDetector>}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDetectors}.
         */
        public String iBMWatsonxAiDetectors() {
            return "CamelIBMWatsonxAiDetectors";
        }
        /**
         * Whether harmful content was detected.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDetected}.
         */
        public String iBMWatsonxAiDetected() {
            return "CamelIBMWatsonxAiDetected";
        }
        /**
         * Detection results grouped by type.
         * 
         * The option is a: {@code java.util.Map} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDetectionResults}.
         */
        public String iBMWatsonxAiDetectionResults() {
            return "CamelIBMWatsonxAiDetectionResults";
        }
        /**
         * Count of detections found.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiDetectionCount}.
         */
        public String iBMWatsonxAiDetectionCount() {
            return "CamelIBMWatsonxAiDetectionCount";
        }
        /**
         * Consumer for streaming text.
         * 
         * The option is a: {@code java.util.function.Consumer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiStreamConsumer}.
         */
        public String iBMWatsonxAiStreamConsumer() {
            return "CamelIBMWatsonxAiStreamConsumer";
        }
        /**
         * Input token count.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiInputTokenCount}.
         */
        public String iBMWatsonxAiInputTokenCount() {
            return "CamelIBMWatsonxAiInputTokenCount";
        }
        /**
         * Output token count.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiOutputTokenCount}.
         */
        public String iBMWatsonxAiOutputTokenCount() {
            return "CamelIBMWatsonxAiOutputTokenCount";
        }
        /**
         * Stop reason for generation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiStopReason}.
         */
        public String iBMWatsonxAiStopReason() {
            return "CamelIBMWatsonxAiStopReason";
        }
        /**
         * The input schema for time series forecast.
         * 
         * The option is a: {@code com.ibm.watsonx.ai.timeseries.InputSchema}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiForecastInputSchema}.
         */
        public String iBMWatsonxAiForecastInputSchema() {
            return "CamelIBMWatsonxAiForecastInputSchema";
        }
        /**
         * The forecast data.
         * 
         * The option is a: {@code com.ibm.watsonx.ai.timeseries.ForecastData}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiForecastData}.
         */
        public String iBMWatsonxAiForecastData() {
            return "CamelIBMWatsonxAiForecastData";
        }
        /**
         * The forecast results.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiForecastResults}.
         */
        public String iBMWatsonxAiForecastResults() {
            return "CamelIBMWatsonxAiForecastResults";
        }
        /**
         * Number of input data points.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiForecastInputDataPoints}.
         */
        public String iBMWatsonxAiForecastInputDataPoints() {
            return "CamelIBMWatsonxAiForecastInputDataPoints";
        }
        /**
         * Number of output data points.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiForecastOutputDataPoints}.
         */
        public String iBMWatsonxAiForecastOutputDataPoints() {
            return "CamelIBMWatsonxAiForecastOutputDataPoints";
        }
        /**
         * List of foundation models.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiFoundationModels}.
         */
        public String iBMWatsonxAiFoundationModels() {
            return "CamelIBMWatsonxAiFoundationModels";
        }
        /**
         * List of foundation model tasks.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiFoundationModelTasks}.
         */
        public String iBMWatsonxAiFoundationModelTasks() {
            return "CamelIBMWatsonxAiFoundationModelTasks";
        }
        /**
         * Filter for foundation models or tasks.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiFoundationModelFilter}.
         */
        public String iBMWatsonxAiFoundationModelFilter() {
            return "CamelIBMWatsonxAiFoundationModelFilter";
        }
        /**
         * Include tech preview models.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonxAiFoundationModelTechPreview}.
         */
        public String iBMWatsonxAiFoundationModelTechPreview() {
            return "CamelIBMWatsonxAiFoundationModelTechPreview";
        }
        /**
         * The tool name to run.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiToolName}.
         */
        public String iBMWatsonxAiToolName() {
            return "CamelIBMWatsonxAiToolName";
        }
        /**
         * The tool request object.
         * 
         * The option is a: {@code com.ibm.watsonx.ai.tool.ToolRequest} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiToolRequest}.
         */
        public String iBMWatsonxAiToolRequest() {
            return "CamelIBMWatsonxAiToolRequest";
        }
        /**
         * The tool configuration.
         * 
         * The option is a: {@code java.util.Map} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiToolConfig}.
         */
        public String iBMWatsonxAiToolConfig() {
            return "CamelIBMWatsonxAiToolConfig";
        }
        /**
         * List of available utility tools.
         * 
         * The option is a: {@code java.util.List} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiUtilityTools}.
         */
        public String iBMWatsonxAiUtilityTools() {
            return "CamelIBMWatsonxAiUtilityTools";
        }
        /**
         * Tool registry for chat with tool calling capabilities.
         * 
         * The option is a: {@code com.ibm.watsonx.ai.chat.ToolRegistry} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiToolRegistry}.
         */
        public String iBMWatsonxAiToolRegistry() {
            return "CamelIBMWatsonxAiToolRegistry";
        }
        /**
         * List of tool calls requested by the assistant.
         * 
         * The option is a: {@code
         * java.util.List<com.ibm.watsonx.ai.chat.model.ToolCall>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiToolCalls}.
         */
        public String iBMWatsonxAiToolCalls() {
            return "CamelIBMWatsonxAiToolCalls";
        }
        /**
         * Whether the assistant response contains tool calls.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiHasToolCalls}.
         */
        public String iBMWatsonxAiHasToolCalls() {
            return "CamelIBMWatsonxAiHasToolCalls";
        }
        /**
         * The full assistant message from chat response.
         * 
         * The option is a: {@code
         * com.ibm.watsonx.ai.chat.model.AssistantMessage} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonxAiAssistantMessage}.
         */
        public String iBMWatsonxAiAssistantMessage() {
            return "CamelIBMWatsonxAiAssistantMessage";
        }
    }
    static WatsonxAiEndpointBuilder endpointBuilder(String componentName, String path) {
        class WatsonxAiEndpointBuilderImpl extends AbstractEndpointBuilder implements WatsonxAiEndpointBuilder, AdvancedWatsonxAiEndpointBuilder {
            public WatsonxAiEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WatsonxAiEndpointBuilderImpl(path);
    }
}