// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from "@hey-api/client-axios";

import type {
  CreateTokenData,
  CreateTokenError,
  CreateTokenResponse,
  CreateTokenAllAdminsError,
  CreateTokenAllAdminsResponse,
  CreateTokenCliData,
  CreateTokenCliError,
  CreateTokenCliResponse,
} from "./types.gen";

export const client = createClient(createConfig());

/**
 * Create Token
 * Authenticate the user.
 */
export const createToken = <ThrowOnError extends boolean = false>(
  options: Options<CreateTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTokenResponse, CreateTokenError, ThrowOnError>({
    ...options,
    url: "/auth/token",
  });
};

/**
 * Create Token All Admins
 * Create a token with no credentials only if ``simple_auth_manager_all_admins`` is True.
 */
export const createTokenAllAdmins = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CreateTokenAllAdminsResponse,
    CreateTokenAllAdminsError,
    ThrowOnError
  >({
    ...options,
    url: "/auth/token",
  });
};

/**
 * Login All Admins
 * Login the user with no credentials.
 */
export const loginAllAdmins = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<void, unknown, ThrowOnError>({
    ...options,
    url: "/auth/token/login",
  });
};

/**
 * Create Token Cli
 * Authenticate the user for the CLI.
 */
export const createTokenCli = <ThrowOnError extends boolean = false>(
  options: Options<CreateTokenCliData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTokenCliResponse, CreateTokenCliError, ThrowOnError>({
    ...options,
    url: "/auth/token/cli",
  });
};
